DATA=$1
OUT=$2
ANS=$3
META=$4
VIZ=$5
WHEN=$6

MODEL="liuhaotian/llava-v1.5-7b" 
MODELTEXT="llava-1.5-7b-liu"

TYPE="oracle"
PROMPT=1
PROMPTTEXT="protocol3when"

source ~/.bashrc
eval "$(conda shell.bash hook)"
conda deactivate
conda activate llava
export PYTHONPATH="../../LLaVA/":"$PWD/../../groundLMM/aas/":$PYTHONPATH
echo $PYTHONPATH

python ../inference/infer_pixfoundation_when.py --root "$DATA" --model-path "$MODEL" --preds_dir "$OUT/preds_${MODELTEXT}_$PROMPTTEXT" --viz_dir "$OUT/viz_${MODELTEXT}_$PROMPTTEXT" --prompt_for_seg $PROMPT --answers_file "$ANS/answers_${MODELTEXT}_$PROMPTTEXT.jsonl" --meta_file "$META/meta_${MODELTEXT}_spaCy_$PROMPTTEXT.txt" --sam-ckpt "sam_checkpoints/sam_vit_h_4b8939.pth"

source ~/.bashrc
eval "$(conda shell.bash hook)"
conda deactivate
conda activate pixmmvp

python ../eval/eval_nonpixLMM_iou.py --preds_dir "${OUT}preds_${MODELTEXT}_${PROMPTTEXT}"  --dataset_root "${DATA}" --viz_dir "${VIZ}/viz_${MODELTEXT}_${PROMPTTEXT}_${TYPE}/" --type $TYPE
python ../eval/eval_nonpixLMM_when_analysis.py --preds_dir "${OUT}preds_${MODELTEXT}_${PROMPTTEXT}"  --dataset_root "${DATA}" --meta_file "$META/meta_${MODELTEXT}_spaCy_$PROMPTTEXT.txt" --when_out_dir "${WHEN}/${MODELTEXT}_${PROMPTTEXT}_${TYPE}/"

