# UQ-Guided Hyperparameter Optimization for Iterative Learners

This paper delves into the pivotal role that uncertainty play in hyperparameter optimization (HPO) and introduces *UQ-guided scheme* for incorporating UQ into the design of HPO, and discusses examples of ways to use the UQ-
guided scheme to enhance existing HPO methods with empirical experiments.

<!-- We introduce criteria that incorporate uncertainty and substantiate their practical significance through empirical experimentation. By shedding light on the influence of criterion selection, this research offers valuable insights for enhancing the effectiveness of HPO.-->

The code used for empirical experiments are available in this repository for validation and replication.


## Installation

### Benchmark Setup
1. Nas-Bench-201
    
    We make use of the high-level APIs defined in [HPOBench](https://github.com/automl/HPOBench) to access Nas-Bench-201. Here, we provide straightforward instructions on how to install it:
    ```bash
    git clone https://github.com/automl/HPOBench.git
    cd HPOBench
    pip install .
    ```

2. LCBench
    ```bash
    git clone https://github.com/automl/LCBench.git
    cd LCBench
    cat requirements.txt | xargs -n 1 -L 1 pip install
    ```

## Obtaining Results

The UQ-scheme is located in the scheme file. The files `{methods}_eval_fraction.py` are used for evaluating the methods and obatining the results.





## 
**Copyright**:  The copyright of this repository belongs to the authors of the NeurIPSL'2024 paper submission (#4023). The purpose of this package is only for the assessment by the ICML'2024 program committee during the paper review process; any other uses for any other purposes are prohibited.