# import required libraries
from scipy.stats import norm
from scipy.stats import expon
import numpy as np
import matplotlib.pyplot as plt
import seaborn as sb

# Creating the distribution
data = np.arange(1,10,0.01)
pdf = norm.pdf(data , loc = 5.3 , scale = 1 )
 
#Visualizing the distribution
 
'''
sb.set_style('whitegrid')
sb.lineplot(data, pdf , color = 'black')
plt.xlabel('Heights')
plt.ylabel('Probability Density')
'''

def Phi(x, mean = 0, sd = 1):
	return norm(loc = mean, scale = sd).cdf(x)

def phi(x, mean = 0, sd = 1):
	return norm(loc = mean, scale = sd).pdf(x)

import time
from timeit import default_timer as timer
def get_topk_confidence(mu_array, m, sigma, threshold=0.85):

	n = len(mu_array)
	probability = 0.0


	total_iteration = round(1.0 / sigma)
	if sigma < 0.05:
		total_iteration *= 2
	y = 1.0 / total_iteration
	delta_y = 1.0 / total_iteration

	total_pdf = 0

	for iteration in range(total_iteration):

		part_1 = 0.0
		part_2 = 1.0

		y += delta_y

		for i in range(m):
#			x = (y - mu_array[i]) / sigma
			phi_x = phi(y, mu_array[i], sigma)
			Phi_x = Phi(y, mu_array[i], sigma)
#			print("[i] : phi Phi", y, phi_x, Phi_x)
			if Phi_x > 1e-120:
				part_1 += phi_x / Phi_x
			part_2 *= Phi_x
#			print(x)

		total_pdf += part_1 * part_2 * delta_y
#		print(total_pdf)

		for i in range(m, n):
#			print(i)
#			x = (y - mu_array[i]) / sigma
			part_2 *= Phi(y, mu_array[i], sigma)

		probability += part_1 * part_2 * delta_y
#		print(y, probability)

	print("probability = ", probability)
#	print("total pdf = ", total_pdf / sigma)
	print("total pdf = ", total_pdf)

	return probability


### The probability that X1 > X2
def get_pair_wise_confidence(mu_1, sigma_1, mu_2, sigma_2, threshold = 0.85):
	probability = 0.0

	print('[mu_1, sigma_1, mu_2, sigma_2]')
	print(mu_1, sigma_1, mu_2, sigma_2)

	probability = Phi((mu_1 - mu_2) / np.sqrt(sigma_1 * sigma_1 + sigma_2 * sigma_2))
	print('probability = ', probability)

	return probability

#print(get_pair_wise_confidence(0.29, 0.1, 0.18, 0.01))


### Use linear regression for predicting converged accuracy
### Input: e, the metric (accuracy) history
from sklearn.linear_model import LinearRegression

def get_learning_curve_mean_and_sigma(e):
    # Learning curve mean 
    # \theta = (W^{1/2}A)+W^{1/2}e = Me
    length = len(e)

    model = LinearRegression()

    x = np.array([i + 1 for i in range(length)]).reshape(-1, 1)
    e = -1 * np.array(e) ## make the accuracy positive
    model.fit(x, e)

    accuracy_pred = model.predict(np.array(180).reshape(-1, 1))

    preds = model.predict(x)
    sigma = np.var(np.abs(e - preds))

    return min(0.9, accuracy_pred[0]), sigma

### The probability that Pred(X1) > Pred(X2)
### e: history of negative accuracy
def get_pair_wise_confidence_learning(e_1, sigma_1_underlying, e_2, sigma_2_underlying, threshold = 0.85):
	probability = 0.0


	mu_1, sigma_1_momentum = get_learning_curve_mean_and_sigma(e_1)
	mu_2, sigma_2_momentum = get_learning_curve_mean_and_sigma(e_2)

	

	#### over 0.9 --> 90%
	if mu_1 >= 0.9 - 1e-3 and mu_2 >= 0.9 - 1e-3:
		return 1.0

	return get_pair_wise_confidence(mu_1, sigma_1_underlying + sigma_1_momentum, mu_2, sigma_2_underlying + sigma_2_momentum, threshold)

#print(get_pair_wise_confidence_learning([-0.02, -0.03, -0.04], 0.05, [-0.03, -0.033, -0.035], 0.06))

'''
### for testing
mu_array = []
mu_array = [0.28, 0.25, .24, .213, .19]
print(get_confidence_curve(mu_array, 0.2))
#print(get_topk_confidence(mu_array, 2, 0.2))
exit()
'''



def get_topk_confidence_backup(mu_array, m, sigma):

	n = len(mu_array)
	probability = 0.0

	part_1 = 0.0
	part_2 = 1.0

	total_iteration = 100
	y = 1.0 / total_iteration
	delta_y = 1.0 / total_iteration

	total_pdf = 0

	for iteration in range(total_iteration):

		y += delta_y

		for i in range(m):
			x = (y - mu_array[i]) / sigma
			phi_x = phi(x)
			Phi_x = Phi(x)
			part_1 += phi_x / Phi_x
			part_2 *= Phi_x
#			print(x)

		total_pdf += part_1 * part_2 * delta_y

		for i in range(m, n):
			print(i)
			x = (y - mu_array[i]) / sigma
			part_2 *= Phi(x)

		probability += part_1 * part_2 * delta_y

	print("probability = ", probability)
	print("total pdf = ", total_pdf)
	return probability / (sigma * 100)

def get_confidence_curve(mu_array, sigma, n_models=5, threshold=0.85):
	n_configurations = len(mu_array)
	n_configurations = min(n_configurations, n_models)

	start = timer()
	confidence_curve = []
	for i in range(n_configurations):
		probability = get_topk_confidence(mu_array, i + 1, sigma)
		confidence_curve.append(probability)
		if probability > threshold:
			break

	print("Processing time (sec) : {}".format(timer() - start))
	return confidence_curve

'''	
print(get_confidence_curve(mu_array, 0.2))
mu_array = []
mu_array = [0.5, 0.25, .24, .213, .19]
#print(get_topk_confidence(mu_array, 1, 0.1))
exit()
'''

def get_next_round_n_model(mu_array, sigma, threshold=0.9, n_models=5):
	n_configurations = len(mu_array)
	n_configurations = min(n_configurations, n_models)
	confidence_curve = get_confidence_curve(mu_array, sigma, n_models, threshold)

	print("confidence_curve = ", confidence_curve)


	n_model = 1
	while True:
		if n_configurations == n_model or confidence_curve[n_model - 1] > threshold:
			break
		n_model += 1

	return n_model

'''
mu_array = []
mu_array = [.253, .2526, .2529, .213, .19]
print(get_next_round_n_model(mu_array, sigma = 0.01, threshold = 0.85, n_models=3))
exit()
'''

def get_new_sigma(total_resources_per_model):
	'''
	Add segment-based approximation
	'''
	x = total_resources_per_model
	if x <= 5:
		return 0.035
	if x < 50:
		return expon.pdf((x - 5)/45) / 27
	else:
		return 0.0023 + 0.000033 * (x - 50)

def get_sigma(total_resources_per_model):
	return get_new_sigma(total_resources_per_model)
	theta = 1
	x = total_resources_per_model / 50
	### mini simulation
#	x = total_resources_per_model - 1
	return expon.pdf(x) / 5


