#/bin/bash

#export PYTHONPATH="${PYTHONPATH}:/workspace/code"
#export GPU_ID=0,1
export GPU_ID=1

checkpoint_path=/mnt/efs/fs2/hzt/causal/Optimus/checkpoints/
output_path=/mnt/efs/fs2/hzt/causal/Optimus/outputs/

## Yelp

#TRAIN_FILE=data/datasets/yelp_data_tst/small/train.txt
#TEST_FILE=data/datasets/yelp_data_tst/small/test.txt
TRAIN_FILE=data/datasets/yelp_data_tst/full/train.txt
TEST_FILE=data/datasets/yelp_data_tst/full/dev.txt
#TEST_FILE=data/datasets/yelp_data_tst/full/dev.txt.sub.0.10

CUDA_VISIBLE_DEVICES=$GPU_ID python3 code/examples/big_ae/run_lm_vae_training.py \
    --output_dir=${output_path}/finetune_lm/yelp \
    --dataset Yelp \
    --encoder_model_type=bert \
    --encoder_model_name_or_path=bert-base-cased \
    --decoder_model_type=gpt2 \
    --decoder_model_name_or_path=gpt2 \
    --beta 0.0 \
    --ratio_zero 0.5 \
    --ratio_increase 0.25 \
    --do_train \
    --do_eval \
    --fb_mode 1 \
    --dim_target_kl 0.5\
    --train_data_file=$TRAIN_FILE \
    --eval_data_file=$TEST_FILE \
    --num_train_epochs 1.0 \
    --save_steps 1000 \
    --logging_steps 1000 \
    --overwrite_output_dir \
    --block_size 100 \
    --length_weighted_loss \
    --use_pretrained_model \
    --use_pretrained_vae \
    --checkpoint_dir=${checkpoint_path}/checkpoint-31250 \
    --gloabl_step_eval 31250 \
    --latent_size 768 \
    --evaluate_during_training \
    --per_gpu_train_batch_size 64 \
    --per_gpu_eval_batch_size 64




## SNLI

#export TRAIN_FILE=data/datasets/snli_data/train.txt
#export TEST_FILE=data/datasets/snli_data/test.txt
#
#CUDA_VISIBLE_DEVICES=$GPU_ID python3 code/examples/big_ae/run_lm_vae_training.py \
#    --output_dir=${output_path}/finetune_lm/snli \
#    --dataset Snli \
#    --encoder_model_type=bert \
#    --encoder_model_name_or_path=bert-base-cased \
#    --decoder_model_type=gpt2 \
#    --decoder_model_name_or_path=gpt2 \
#    --beta 0.0 \
#    --ratio_zero 0.5 \
#    --ratio_increase 0.25 \
#    --do_train \
#    --do_eval \
#    --fb_mode 1 \
#    --dim_target_kl 0.5\
#    --train_data_file=$TRAIN_FILE \
#    --eval_data_file=$TEST_FILE \
#    --num_train_epochs 1.0 \
#    --save_steps 1000 \
#    --logging_steps 1000 \
#    --overwrite_output_dir \
#    --block_size 100 \
#    --length_weighted_loss \
#    --use_pretrained_model \
#    --use_pretrained_vae \
#    --checkpoint_dir=${checkpoint_path}/checkpoint-31250 \
#    --gloabl_step_eval 31250 \
#    --latent_size 768 \
#    --evaluate_during_training \
#    --per_gpu_train_batch_size 5 \
#    --per_gpu_eval_batch_size 5
#
#
#    #--checkpoint_dir ../output/pretrain/philly_rr3_vc4_g8_base_vae_wikipedia_pretraining_beta_schedule_beta0.0_d1.0_ro0.5_ra0.25_32_v2/checkpoint-508523 \
#    #--gloabl_step_eval 508523
