#/bin/bash

#export PYTHONPATH="${PYTHONPATH}:/workspace/code"
#export GPU_ID=0,1
export GPU_ID=2

checkpoint_path=/mnt/efs/fs2/hzt/causal/Optimus/checkpoints/
output_path=/mnt/efs/fs2/hzt/causal/Optimus/outputs/

## Yelp

debug=0

attribute_dim=50
if [ "$debug" -eq 1 ]
then
    #TRAIN_FILE=data/datasets/yelp_data_tst/small/train.txt
    #TEST_FILE=data/datasets/yelp_data_tst/small/train.txt
    #logging_steps=1

    #TRAIN_FILE=data/datasets/yelp_data_tst/full/test.txt.sub.0.005
    #TEST_FILE=data/datasets/yelp_data_tst/full/test.txt.sub.0.005
    #logging_steps=40

    TRAIN_FILE=data/datasets/yelp_data_tst/full/train.txt.sub.6000
    TEST_FILE=data/datasets/yelp_data_tst/full/train.txt.sub.6000
    logging_steps=400

    save_steps=10000
    per_gpu_train_batch_size=8
    per_gpu_eval_batch_size=8
    num_train_epochs=50
else
    TRAIN_FILE=data/datasets/yelp_data_tst/full/train.txt
    #TRAIN_FILE=data/datasets/yelp_data_tst/full/train.txt.sub.20000  # TODO(hzt)
    #TEST_FILE=data/datasets/yelp_data_tst/full/dev.txt
    TEST_FILE=data/datasets/yelp_data_tst/full/dev.txt.sub.0.10
    #TEST_FILE=data/datasets/yelp_data_tst/full/test.txt.sub.0.005
    #TEST_FILE=data/datasets/yelp_data_tst/full/train.txt.sub.6000
    logging_steps=1000
    save_steps=1000
    #per_gpu_train_batch_size=64
    #per_gpu_eval_batch_size=64
    per_gpu_train_batch_size=16
    per_gpu_eval_batch_size=16
    num_train_epochs=10
fi


    #--output_dir=${output_path}/finetune_lm/yelp_na${attribute_dim}_10ep/outputs-31250-69000/s2-debug-gsfixed_train6k_ep50 \
    #--gumbel_hard \

CUDA_VISIBLE_DEVICES=$GPU_ID python3 code/examples/big_ae/run_lm_vae_clas_training_bak.py \
    --use_deterministic_connect \
    --use_gumbel \
    --output_dir=${output_path}/finetune_lm/yelp_na${attribute_dim}_10ep/outputs-31250-69000/s2-gsfixed-newmask-t1_w01_wr1_lr1e6_gumbel_samelen_bz16_dtrm_bak \
    --learning_rate 1e-6 \
    --temperature=1. \
    --lambda_clas=0.1 \
    --lambda_recon=1. \
    --temperature_anneal_factor=1 \
    --temperature_anneal_iters=20000 \
    --checkpoint_dir=${output_path}/finetune_lm/yelp_na50_10ep/checkpoint-31250-69000 \
    --gloabl_step_eval 69000 \
    --attribute_dim $attribute_dim \
    --dataset Yelp \
    --encoder_model_type=bert \
    --encoder_model_name_or_path=bert-base-cased \
    --decoder_model_type=gpt2 \
    --decoder_model_name_or_path=gpt2 \
    --classifier_model_type=gpt2-clas \
    --classifier_model_name_or_path=gpt2 \
    --beta 0.0 \
    --ratio_zero 0.5 \
    --ratio_increase 0.25 \
    --do_train \
    --do_eval \
    --fb_mode 1 \
    --dim_target_kl 0.5\
    --train_data_file=$TRAIN_FILE \
    --eval_data_file=$TEST_FILE \
    --num_train_epochs ${num_train_epochs} \
    --save_steps ${save_steps}\
    --logging_steps ${logging_steps} \
    --overwrite_output_dir \
    --block_size 100 \
    --length_weighted_loss \
    --use_pretrained_model \
    --use_pretrained_vae \
    --latent_size 768 \
    --evaluate_during_training \
    --per_gpu_train_batch_size ${per_gpu_train_batch_size} \
    --per_gpu_eval_batch_size ${per_gpu_eval_batch_size}

    #--checkpoint_dir=${checkpoint_path}/checkpoint-31250 \


    #--output_dir=${output_path}/finetune_lm/yelp_na${attribute_dim}_10ep/outputs-31250-69000/t1_w01_anl4000_step05_gumbel_len20_bz16_dtrm \
    #--checkpoint_dir=${output_path}/finetune_lm/yelp_na50_10ep/checkpoint-31250-69000 \
    #--gloabl_step_eval 69000 \

    #--output_dir=${output_path}/finetune_lm/yelp_na${attribute_dim}_10ep_dtrm \
    #--checkpoint_dir=${checkpoint_path}/checkpoint-31250 \
    #--gloabl_step_eval 31250 \


# =====================

## SNLI

#export TRAIN_FILE=data/datasets/snli_data/train.txt
#export TEST_FILE=data/datasets/snli_data/test.txt
#
#CUDA_VISIBLE_DEVICES=$GPU_ID python3 code/examples/big_ae/run_lm_vae_training.py \
#    --output_dir=${output_path}/finetune_lm/snli \
#    --dataset Snli \
#    --encoder_model_type=bert \
#    --encoder_model_name_or_path=bert-base-cased \
#    --decoder_model_type=gpt2 \
#    --decoder_model_name_or_path=gpt2 \
#    --beta 0.0 \
#    --ratio_zero 0.5 \
#    --ratio_increase 0.25 \
#    --do_train \
#    --do_eval \
#    --fb_mode 1 \
#    --dim_target_kl 0.5\
#    --train_data_file=$TRAIN_FILE \
#    --eval_data_file=$TEST_FILE \
#    --num_train_epochs 1.0 \
#    --save_steps 1000 \
#    --logging_steps 1000 \
#    --overwrite_output_dir \
#    --block_size 100 \
#    --length_weighted_loss \
#    --use_pretrained_model \
#    --use_pretrained_vae \
#    --checkpoint_dir=${checkpoint_path}/checkpoint-31250 \
#    --gloabl_step_eval 31250 \
#    --latent_size 768 \
#    --evaluate_during_training \
#    --per_gpu_train_batch_size 5 \
#    --per_gpu_eval_batch_size 5
#
#
#    #--checkpoint_dir ../output/pretrain/philly_rr3_vc4_g8_base_vae_wikipedia_pretraining_beta_schedule_beta0.0_d1.0_ro0.5_ra0.25_32_v2/checkpoint-508523 \
#    #--gloabl_step_eval 508523
