
import os
import json
import time
import subprocess
# from google3.pyglib import gfile
import pandas as pd
import numpy as np
import random

from tqdm import tqdm,trange
from scipy import stats
from collections import defaultdict,Counter

from collections.abc import Collection, Mapping, Sequence
import dataclasses
import enum
import json
import textwrap
from typing import Optional, Tuple, Union
import urllib
# from colabtools import drive

import numpy as np
import math

class SudoArgs:
  exist = None

DATA_DIR = "./"



train_file = os.path.join(DATA_DIR, "training_file_pddl_plan_v6.json")
dev_file = os.path.join(DATA_DIR, "dev_file_pddl_plan_v6.json")


# # File Load and Tests

ex_input="""
(define (problem BW-rand-6)
(:domain blocksworld-4ops)
(:objects b1 b5 b2 b4 b3 b6)
(:init
(on b2 b5)
(clear b3)
(on b4 b2)
(handempty)
(on b3 b4)
(ontable b1)
(on b5 b1)
(ontable b6)
(clear b6)
)
(:goal (and
(on b5 b4)
(on b3 b5)
))
)
"""

ex_plan="""
(unstack b3 b4)
(put-down b3)
(unstack b4 b2)
(put-down b4)
(unstack b2 b5)
(put-down b2)
(unstack b5 b1)
(stack b5 b4)
(pick-up b3)
(stack b3 b5)
"""



PDDL_EXECUTABLE = '../planning/VAL/validate'

def call_pddl_validator(domain: str, instance: str, plan: str) -> bool:
  """Run the PDDL validation tool.

  Args:
    domain: problem domain file in pddl
    instance: problem instance file in pddl
    plan: plan file in htn

  Returns:
    Plan verification result.
  """
  # Ensure executable.
  os.chmod(PDDL_EXECUTABLE, 0o755) #-a

  val_exe = f'{PDDL_EXECUTABLE} -v -a %s %s %s' % (
      domain,
      instance,
      plan,
  )

  response = subprocess.run(
      val_exe, shell=True, check=False, capture_output=True
  )
  # print(response)

  if b'Successful plans' in response.stdout or b'Plan valid' in response.stdout:
    return 2

  elif (response is not None) and (b'Plan executed successfully' in response.stdout or b'Goal not satisfied' in response.stdout):
    return 1

  elif (response is not None) and (b'Plan failed to execute' in response.stdout):
    return 0

  return 0


def pddl_validate_plan(
    plan: str,
    instance: str,
    domain_path: str,
    # cmd_args: str = '-a',
    debug: bool = True,
) -> float:

  plan_path = os.path.join('./', 'plans.pddl')
  with open(plan_path, 'w') as f:
    f.write(plan)
  instance_path = os.path.join('./', 'instances.pddl')
  with open(instance_path, 'w') as f:
    f.write(instance)

  result = call_pddl_validator(
      domain_path,
      instance_path,
      plan_path,
  )

  return result

def icl_scoring_main(output_collection):

  score_collection = []
  goal_collection = []

  # print(len(output_collection))
  for i, item in enumerate(tqdm(output_collection)):
    domain_path = "../planning/data/block_generated_domain.pddl"

    this_goal = []
    this_score = []
    for response in item[-1]:
      result = pddl_validate_plan(response, item[0], domain_path=domain_path)
      # print(result)
      if result == 0:
        this_score.append(0)
        this_goal.append(0)
      elif result == 1:
        this_score.append(1)
        this_goal.append(0)

      elif result == 2:
        this_score.append(1)
        this_goal.append(1)

    score_collection.append(max(this_score))
    goal_collection.append(max(this_goal))

  print("Plan Valid",sum(score_collection)/len(score_collection))
  print("Goal Achieved:",sum(goal_collection)/len(goal_collection))

  return score_collection, goal_collection


for demo_num in [10]:#1,2,4,10,20,40,10,100,200
  for icl_sim_mode in ["gecko"]:
    
    print("Demo Num:", demo_num,"|", icl_sim_mode)
    results = []
    filename = f"./results/{demo_num}-pivot-{icl_sim_mode}-pass@5.json"

    with open(filename, 'r') as f:
      raw_output_collection = json.load(f)

    output_collection = []

    for row in raw_output_collection:
      output_collection.append([row["question"],row["response"][:1]])

    score_collection, goal_collection = icl_scoring_main(output_collection)

    save_filenames = f"./results/{demo_num}-{icl_sim_mode}-acc.json"

    with open(save_filenames,"w") as f:
      json.dump(goal_collection, f)
