import argparse
import pickle
from knotty.run.run import run
from knotty.utils import default_args, parser, save_results_and_args, \
    RESULTS_LOCAL_DIRNAME, dict_diff, \
    setup_wandb, wandb_init, update_wandb_config
from datetime import datetime
import json, os, copy
import ipdb
import time
from multiprocessing import Process, freeze_support


if __name__ == "__main__":

    time_stamp = datetime.today().strftime('%H:%M')
    day_stamp = datetime.today().strftime('%m-%d-%y')

    parsed_args = parser.parse_args()
    args = copy.deepcopy(default_args)
    args.update(parsed_args.__dict__)
    new_args = dict_diff(args, default_args)

    print(args)
    n = args['n_train']
    p = args['num_knots']
    dirname = os.path.join(os.environ['RESULTS_DIRNAME'], RESULTS_LOCAL_DIRNAME, day_stamp,args["dataset_name"])
    # filename = f'_timestamp={time_stamp}' + f'n={n}'+f'-p={p}'#'_'.join([f'{k}={v}' for k,v in new_args.items()]) + f'_timestamp={time_stamp}'    kerneltype = args['kernel_type']
    bandwidth = args['bandwidth']
    filename = f'n={n}'+f'-p={p}'+f'-kernel={kerneltype}'+f'-bandwidth={bandwidth}'+f'_timestamp={time_stamp}'

    project_name =  os.environ['WANDB_PROJECT_NAME']
    wandb_init['name'] = f'n={n}, p={p}'
    wandb_init['project_name'] = project_name
    wandb_run = setup_wandb(wandb_init)
    update_wandb_config(args,wandb_run.config)

    alpha, acc_valid_ep3,nystrom_samples,knots_x,acc_ep2_test= run(**args,wandb_run=wandb_run)
    result_dict = {'alpha':alpha,'acc_valid_ep3':acc_valid_ep3,
                   'nystrom_samples':nystrom_samples,'knots_x':knots_x,
                   'acc_ep2_test':acc_ep2_test}

    save_results_and_args(result_dict , args, dirname, filename)


