#!/bin/bash

# RATE
python3 src/train.py --arch-mode=TrXL --data.gamma=1 --data.path-to-dataset=data/ViZDoom_Two_Colors_150/ --end-seed=6 --model-mode=RATE --model.act-dim=5 --model.d-head=64 --model.d-inner=128 --model.d-model=64 --model.dropatt=0.05 --model.dropout=0.2 --model.env-name=vizdoom --model.ext-len=0 --model.mem-at-end=True --model.mem-len=100 --model.mrv-act=relu --model.n-head=8 --model.n-head-ca=2 --model.n-layer=6 --model.num-mem-tokens=15 --model.padding-idx=None --model.skip-dec-ffn=False --model.state-dim=3 --online-inference.best_checkpoint_metric=ReturnsMean_56.5 --online-inference.desired-return-1=56.5 --online-inference.episode-timeout=4200 --online-inference.use-argmax=False --start-seed=1 --tensorboard-dir=runs/ViZDoom_Two_Colors/RATE --text=RATE --training.batch-size=128 --training.beta-1=0.9 --training.beta-2=0.999 --training.ckpt-epoch=15 --training.context-length=50 --training.epochs=150 --training.final-tokens=10000000 --training.grad-norm-clip=5 --training.learning-rate=0.0003 --training.log-last-segment-loss-only=False --training.lr-end-factor=0.01 --training.online-inference=True --training.sections=3 --training.use-cosine-decay=False --training.warmup-steps=30000 --training.weight-decay=0.001 --wandb.project-name=RATE-ViZDoom-Two-Colors --wandb.wwandb=True

# DT
python3 src/train.py --arch-mode=TrXL --data.gamma=1 --data.path-to-dataset=data/ViZDoom_Two_Colors_150/ --end-seed=6 --model-mode=DT --model.act-dim=5 --model.d-head=64 --model.d-inner=128 --model.d-model=64 --model.dropatt=0.05 --model.dropout=0.2 --model.env-name=vizdoom --model.ext-len=0 --model.mem-at-end=False --model.mem-len=0 --model.mrv-act=no_act --model.n-head=8 --model.n-head-ca=0 --model.n-layer=6 --model.num-mem-tokens=0 --model.padding-idx=None --model.skip-dec-ffn=False --model.state-dim=3 --online-inference.best_checkpoint_metric=ReturnsMean_56.5 --online-inference.desired-return-1=56.5 --online-inference.episode-timeout=4200 --online-inference.use-argmax=False --start-seed=1 --tensorboard-dir=runs/ViZDoom_Two_Colors/DT --text=DT --training.batch-size=128 --training.beta-1=0.9 --training.beta-2=0.999 --training.ckpt-epoch=15 --training.context-length=50 --training.epochs=150 --training.final-tokens=10000000 --training.grad-norm-clip=5 --training.learning-rate=0.0003 --training.log-last-segment-loss-only=False --training.lr-end-factor=0.01 --training.online-inference=True --training.sections=3 --training.use-cosine-decay=False --training.warmup-steps=30000 --training.weight-decay=0.001 --wandb.project-name=RATE-ViZDoom-Two-Colors --wandb.wwandb=True

# RMT
python3 src/train.py --arch-mode=TrXL --data.gamma=1 --data.path-to-dataset=data/ViZDoom_Two_Colors_150/ --end-seed=6 --model-mode=RMT --model.act-dim=5 --model.d-head=64 --model.d-inner=128 --model.d-model=64 --model.dropatt=0.05 --model.dropout=0.2 --model.env-name=vizdoom --model.ext-len=0 --model.mem-at-end=True --model.mem-len=0 --model.mrv-act=no_act --model.n-head=8 --model.n-head-ca=0 --model.n-layer=6 --model.num-mem-tokens=15 --model.padding-idx=None --model.skip-dec-ffn=False --model.state-dim=3 --online-inference.best_checkpoint_metric=ReturnsMean_56.5 --online-inference.desired-return-1=56.5 --online-inference.episode-timeout=4200 --online-inference.use-argmax=False --start-seed=1 --tensorboard-dir=runs/ViZDoom_Two_Colors/RMT --text=RMT --training.batch-size=128 --training.beta-1=0.9 --training.beta-2=0.999 --training.ckpt-epoch=15 --training.context-length=50 --training.epochs=150 --training.final-tokens=10000000 --training.grad-norm-clip=5 --training.learning-rate=0.0003 --training.log-last-segment-loss-only=False --training.lr-end-factor=0.01 --training.online-inference=True --training.sections=3 --training.use-cosine-decay=False --training.warmup-steps=30000 --training.weight-decay=0.001 --wandb.project-name=RATE-ViZDoom-Two-Colors --wandb.wwandb=True

# TrXL
python3 src/train.py --arch-mode=TrXL --data.gamma=1 --data.path-to-dataset=data/ViZDoom_Two_Colors_150/ --end-seed=6 --model-mode=TrXL --model.act-dim=5 --model.d-head=64 --model.d-inner=128 --model.d-model=64 --model.dropatt=0.05 --model.dropout=0.2 --model.env-name=vizdoom --model.ext-len=0 --model.mem-at-end=False --model.mem-len=450 --model.mrv-act=no_act --model.n-head=8 --model.n-head-ca=0 --model.n-layer=6 --model.num-mem-tokens=0 --model.padding-idx=None --model.skip-dec-ffn=False --model.state-dim=3 --online-inference.best_checkpoint_metric=ReturnsMean_56.5 --online-inference.desired-return-1=56.5 --online-inference.episode-timeout=4200 --online-inference.use-argmax=False --start-seed=1 --tensorboard-dir=runs/ViZDoom_Two_Colors/TrXL --text=TrXL --training.batch-size=128 --training.beta-1=0.9 --training.beta-2=0.999 --training.ckpt-epoch=15 --training.context-length=50 --training.epochs=150 --training.final-tokens=10000000 --training.grad-norm-clip=5 --training.learning-rate=0.0003 --training.log-last-segment-loss-only=False --training.lr-end-factor=0.01 --training.online-inference=True --training.sections=3 --training.use-cosine-decay=False --training.warmup-steps=30000 --training.weight-decay=0.001 --wandb.project-name=RATE-ViZDoom-Two-Colors --wandb.wwandb=True

# LSDT
python3 src/train.py --wandb.project-name=RATE-ViZDoom-Two-Colors --wandb.wwandb=True --data.gamma=1.0 --data.path-to-dataset=data/ViZDoom_Two_Colors_150/ --training.learning-rate=0.0003 --training.lr-end-factor=0.01 --training.beta-1=0.9 --training.beta-2=0.999 --training.weight-decay=0.001 --training.batch-size=64 --training.warmup-steps=30000 --training.final-tokens=10000000 --training.grad-norm-clip=5.0 --training.epochs=250 --training.ckpt-epoch=25 --training.online-inference=True --training.log-last-segment-loss-only=False --training.use-cosine-decay=False --training.context-length=50 --training.sections=3 --model.env-name=vizdoom --model.state-dim=3 --model.act-dim=5 --model.n-layer=6 --model.n-head=8 --model.d-model=64 --model.dropout=0.2 --model.dropatt=0.1 --model.kernel-size=6 --model.convdim=32 --model.padding-idx=-10 --tensorboard-dir=runs/ViZDoom_Two_Colors/LSDT --model-mode=LSDT --start-seed=1 --end-seed=6 --text=LSDT --online-inference.use-argmax=False --online-inference.episode-timeout=4200 --online-inference.desired-return-1=56.5 --online-inference.best_checkpoint_metric=ReturnsMean_56.5

# BC-MLP
python3 src/train.py --wandb.project-name=RATE-ViZDoom-Two-Colors --wandb.wwandb=True --data.gamma=1.0 --data.path-to-dataset=data/ViZDoom_Two_Colors_150/ --training.learning-rate=0.0003 --training.lr-end-factor=0.01 --training.beta-1=0.9 --training.beta-2=0.999 --training.weight-decay=0.001 --training.batch-size=128 --training.warmup-steps=30000 --training.final-tokens=10000000 --training.grad-norm-clip=5.0 --training.epochs=200 --training.ckpt-epoch=25 --training.online-inference=True --training.log-last-segment-loss-only=False --training.use-cosine-decay=False --training.context-length=50 --training.sections=3 --model.env-name=vizdoom --model.state-dim=3 --model.act-dim=5 --model.d-model=64 --model.dropout=0.2 --model.padding-idx=-10 --model.backbone=mlp --tensorboard-dir=runs/ViZDoom_Two_Colors/BC_MLP --model-mode=BC --start-seed=1 --end-seed=6 --text=BC_MLP --online-inference.best_checkpoint_metric=ReturnsMean_56.5 --online-inference.desired-return-1=56.5 --online-inference.episode-timeout=4200 --online-inference.use-argmax=False

# BC-LSTM
python3 src/train.py --wandb.project-name=RATE-ViZDoom-Two-Colors --wandb.wwandb=True --data.gamma=1.0 --data.path-to-dataset=data/ViZDoom_Two_Colors_150/ --training.learning-rate=0.0003 --training.lr-end-factor=0.01 --training.beta-1=0.9 --training.beta-2=0.999 --training.weight-decay=0.001 --training.batch-size=128 --training.warmup-steps=30000 --training.final-tokens=10000000 --training.grad-norm-clip=5.0 --training.epochs=200 --training.ckpt-epoch=25 --training.online-inference=True --training.log-last-segment-loss-only=False --training.use-cosine-decay=False --training.context-length=50 --training.sections=3 --model.env-name=vizdoom --model.state-dim=3 --model.act-dim=5 --model.d-model=64 --model.dropout=0.2 --model.padding-idx=-10 --model.backbone=lstm --model.lstm_layers=1 --model.bidirectional=False --model.reset_hidden_state_batch=True --tensorboard-dir=runs/ViZDoom_Two_Colors/BC_LSTM --model-mode=BC --start-seed=1 --end-seed=6 --text=BC_LSTM --online-inference.best_checkpoint_metric=ReturnsMean_56.5 --online-inference.desired-return-1=56.5 --online-inference.episode-timeout=4200 --online-inference.use-argmax=False 

# CQL-MLP
python3 src/train.py --wandb.project-name=RATE-ViZDoom-Two-Colors --wandb.wwandb=True --data.gamma=1.0 --data.path-to-dataset=data/ViZDoom_Two_Colors_150/ --training.learning-rate=0.0003 --training.lr-end-factor=0.01 --training.beta-1=0.9 --training.beta-2=0.999 --training.weight-decay=0.001 --training.batch-size=128 --training.warmup-steps=30000 --training.final-tokens=10000000 --training.grad-norm-clip=5.0 --training.epochs=200 --training.ckpt-epoch=25 --training.online-inference=True --training.log-last-segment-loss-only=False --training.use-cosine-decay=False --training.context-length=50 --training.sections=3 --model.env-name=vizdoom --model.state-dim=3 --model.act-dim=5 --model.d-model=64 --model.dropout=0.2 --model.padding-idx=-10 --model.backbone=mlp --tensorboard-dir=runs/ViZDoom_Two_Colors/CQL_MLP --model-mode=CQL --model.cql-alpha=5.0 --start-seed=1 --end-seed=6 --text=CQL_MLP --online-inference.best_checkpoint_metric=ReturnsMean_56.5 --online-inference.desired-return-1=56.5 --online-inference.episode-timeout=4200 --online-inference.use-argmax=False

# CQL-LSTM
python3 src/train.py --wandb.project-name=RATE-ViZDoom-Two-Colors --wandb.wwandb=True --data.gamma=1.0 --data.path-to-dataset=data/ViZDoom_Two_Colors_150/ --training.learning-rate=0.0003 --training.lr-end-factor=0.01 --training.beta-1=0.9 --training.beta-2=0.999 --training.weight-decay=0.001 --training.batch-size=128 --training.warmup-steps=30000 --training.final-tokens=10000000 --training.grad-norm-clip=5.0 --training.epochs=200 --training.ckpt-epoch=25 --training.online-inference=True --training.log-last-segment-loss-only=False --training.use-cosine-decay=False --training.context-length=50 --training.sections=3 --model.env-name=vizdoom --model.state-dim=3 --model.act-dim=5 --model.d-model=64 --model.dropout=0.2 --model.padding-idx=-10 --model.backbone=lstm --model.lstm_layers=1 --model.bidirectional=False --model.reset_hidden_state_batch=True --tensorboard-dir=runs/ViZDoom_Two_Colors/CQL_LSTM --model-mode=CQL --model.cql-alpha=5.0 --start-seed=1 --end-seed=6 --text=CQL_LSTM --online-inference.best_checkpoint_metric=ReturnsMean_56.5 --online-inference.desired-return-1=56.5 --online-inference.episode-timeout=4200 --online-inference.use-argmax=False

# DLSTM
python3 src/train.py --wandb.project-name=RATE-ViZDoom-Two-Colors --wandb.wwandb=True --data.gamma=1.0 --data.path-to-dataset=data/ViZDoom_Two_Colors_150/ --training.learning-rate=0.0003 --training.lr-end-factor=0.01 --training.beta-1=0.9 --training.beta-2=0.999 --training.weight-decay=0.001 --training.batch-size=128 --training.warmup-steps=30000 --training.final-tokens=10000000 --training.grad-norm-clip=5.0 --training.epochs=400 --training.ckpt-epoch=25 --training.online-inference=True --training.log-last-segment-loss-only=False --training.use-cosine-decay=False --training.context-length=50 --training.sections=3 --model.env-name=vizdoom --model.state-dim=3 --model.act-dim=5 --model.d-model=64 --model.dropout=0.2 --model.padding-idx=-10 --model.backbone=lstm --model.lstm_layers=1 --model.bidirectional=False --model.reset_hidden_state_batch=True --tensorboard-dir=runs/ViZDoom_Two_Colors/DLSTM --model-mode=DLSTM --start-seed=1 --end-seed=6 --text=DLSTM --online-inference.use-argmax=False --online-inference.episode-timeout=4200 --online-inference.desired-return-1=56.5 --online-inference.best_checkpoint_metric=ReturnsMean_56.5

# DGRU
python3 src/train.py --wandb.project-name=RATE-ViZDoom-Two-Colors --wandb.wwandb=True --data.gamma=1.0 --data.path-to-dataset=data/ViZDoom_Two_Colors_150/ --training.learning-rate=0.0003 --training.lr-end-factor=0.01 --training.beta-1=0.9 --training.beta-2=0.999 --training.weight-decay=0.001 --training.batch-size=128 --training.warmup-steps=30000 --training.final-tokens=10000000 --training.grad-norm-clip=5.0 --training.epochs=400 --training.ckpt-epoch=25 --training.online-inference=True --training.log-last-segment-loss-only=False --training.use-cosine-decay=False --training.context-length=50 --training.sections=3 --model.env-name=vizdoom --model.state-dim=3 --model.act-dim=5 --model.d-model=64 --model.dropout=0.2 --model.padding-idx=-10 --model.backbone=gru --model.lstm_layers=1 --model.bidirectional=False --model.reset_hidden_state_batch=True --tensorboard-dir=runs/ViZDoom_Two_Colors/DGRU --model-mode=DLSTM --start-seed=1 --end-seed=1 --text=DGRU --online-inference.use-argmax=False --online-inference.episode-timeout=4200 --online-inference.desired-return-1=56.5 --online-inference.best_checkpoint_metric=ReturnsMean_56.5

# DMamba
python3 src/train.py --wandb.project-name=RATE-ViZDoom-Two-Colors --wandb.wwandb=True --data.gamma=1.0 --data.path-to-dataset=data/ViZDoom_Two_Colors_150/ --training.learning-rate=0.0003 --training.lr-end-factor=0.01 --training.beta-1=0.9 --training.beta-2=0.999 --training.weight-decay=0.1 --training.batch-size=128 --training.warmup-steps=30000 --training.final-tokens=10000000 --training.grad-norm-clip=5.0 --training.epochs=400 --training.ckpt-epoch=25 --training.online-inference=True --training.log-last-segment-loss-only=True --training.use-cosine-decay=False --training.context-length=50 --training.sections=3 --model.env-name=vizdoom --model.state-dim=3 --model.act-dim=5 --model.n-layer=4 --model.n-head=4 --model.d-model=64 --model.dropout=0.2 --model.dropatt=0.0 --model.token-mixer=mamba --model.window-size=30 --model.conv-proj=True --tensorboard-dir=runs/ViZDoom_Two_Colors/DMamba --model-mode=DMamba --arch-mode=TrXL --start-seed=1 --end-seed=6 --text=DMamba --online-inference.best_checkpoint_metric=ReturnsMean_56.5 --online-inference.desired-return-1=56.5 --online-inference.episode-timeout=4200 --online-inference.use-argmax=False 