#!/usr/bin/env bash
set -euxo pipefail

# how many iters to skip
skip=4
count=0

# 1) your grid
ds=(10000 20000 50000 100000)
ks=(10 20 50)
lrs=(1e-3 5e-3 1e-2)
deltas=(0.1 0.5)
# the "k‑multipliers" for n_train
multipliers=(20 50 100 200)

# 2) loop & launch
for d in "${ds[@]}"; do
  for k in "${ks[@]}"; do
    for lr in "${lrs[@]}"; do
      for delta in "${deltas[@]}"; do
        for m in "${multipliers[@]}"; do
          n_train=$(( m * k ))
          
          # increment and skip first $skip iters
          count=$((count + 1))
          if [ "$count" -le "$skip" ]; then
            echo "Skipping iteration #$count (d=$d, k=$k, lr=$lr, δ=$delta, n_train=$n_train)"
            continue
          fi

          echo "=== running #$count: d=$d, k=$k, lr=$lr, δ=$delta, n_train=$n_train ==="
          python train_diag_cls.py \
            --d "$d" \
            --k "$k" \
            --lr "$lr" \
            --delta "$delta" \
            --n-train "$n_train" \
            # … add any other fixed flags here (e.g. --L 2 --alpha 1.0 --steps 1000000)
        done
      done
    done
  done
done
