## Gradient Flow on Images Experiment

This directory contains the code for the gradient flow on images experiment presented in the paper.

### Reproducing Results

To replicate the experimental results, execute the main script with the desired loss configurations. The following command runs the experiment for `db_tsw`, `fw_tsw`, and `fw_tsw_rp` losses, saving snapshots at specified iterations:

```bash
python main.py --losses db_tsw fw_tsw fw_tsw_rp --print_steps 999 1999 2499 2999 3999
```

### Summarizing Results and Obtaining Median L2 Loss Images

After running the main experiment, you can summarize the statistics and generate images corresponding to the median L2 loss for each configuration.

1.  **Calculate Statistics:**
    To compute and save the statistical summary of the runs, use:

    ```bash
    python cal_stat.py --print_steps 999,1999,2499,2999,3999
    ```
    This script will process the output from `main.py` for the specified print steps.

2.  **Generate Median L2 Loss Images:**
    To identify and save the images that achieve the median L2 loss at the specified iterations, run:

    ```bash
    python cal_median.py --print_steps 999,1999,2499,2999,3999
    ```
    This script will also use the data generated by `main.py`.
