# Predictive Coding Networks (PCN) Implementation

This repository contains a PyTorch implementation of Predictive Coding Networks with Meta-PC enhancement for deep learning research.


 This implementation includes:
- Standard Predictive Coding (Vanilla PC)
- Meta-PC with frozen predictions for enhanced stability
- Support for multiple network architectures (VGG, ResNet, CNN)
- Efficient GPU utilization and batch processing

## Requirements

- Python 3.8+
- PyTorch 1.10+
- torchvision
- tqdm
- matplotlib
- numpy

## Installation

```bash
cd pcn-implementation
pip install -r requirements.txt
```

## Quick Start

### Basic Training

Train a PCN model on CIFAR-10:

```bash
python train.py --dataset cifar10 --backbone vgg13 --epochs 50
```

### Meta-PCN Training

Train with Meta-PC enhancement:

```bash
python train.py --dataset cifar10 --backbone vgg13 --energy_option meta_pc --loop_schduler blocked_sweep_gs --norm_type variance --epochs 50
```

### Key Parameters

- `--dataset`: Dataset choice (cifar10, cifar100, imagenet)
- `--backbone`: Network architecture (vgg11/13/16/19, resnet18/34/50, shallow_cnn, deep_cnn)
- `--energy_option`: PC variant (vanilla_pc, meta_pc)
- `--T`: Number of inference iterations (default: 20)
- `--eta`: Learning rate for PC updates (default: 0.2)
- `--batch_size`: Batch size for training (default: 128)
- `--epochs`: Number of training epochs (default: 50)

## Project Structure

```
├── train.py                 # Main training script
├── models/                  # PCN model implementations
│   ├── factory.py          # Model factory functions
│   ├── new_pcn_model.py    # Core PCN model
│   ├── config.py           # Configuration management
│   ├── latent_updaters/    # Latent variable update strategies
│   ├── normalization/      # Weight normalization modules
│   └── solvers/            # Fixed-point solvers
├── backbones/              # Network architectures
│   └── net/                # VGG, ResNet, CNN implementations
├── data/                   # Data loading utilities
├── utils/                  # Helper functions
└── README.md              # This file
```

## Model Architecture

The PCN implementation follows a modular design:

1. **Backbone Networks**: Standard deep learning architectures (VGG, ResNet)
2. **Latent Updaters**: Implements PC inference dynamics
3. **Solvers**: Fixed-point iteration for convergence
4. **Normalization**: Optional weight normalization strategies

## Datasets

Currently supported datasets:
- CIFAR-10 (10 classes, 32x32 images)
- CIFAR-100 (100 classes, 32x32 images)
- Tiny-ImageNet (200 classes, 64x64 images)

Data will be automatically downloaded to `./datasets/` on first run.

