"""
Backbone networks for PCN
"""

from .resnet import get_resnet18_modules, get_resnet34_modules, get_resnet50_modules
from .vgg import (
    get_vgg5_modules, get_vgg7_modules, get_vgg9_modules,
    get_vgg11_modules, get_vgg13_modules, get_vgg16_modules, get_vgg19_modules
)
from .vgg2 import (
    get_vgg2_5_modules,
    get_vgg2_7_modules,
    get_vgg2_9_modules,
    get_vgg2_11_modules,
    get_vgg2_13_modules,
    get_vgg2_16_modules,
    get_vgg2_19_modules
)
from .vgg3 import (
    get_vgg3_5_modules,
    get_vgg3_7_modules,
    get_vgg3_9_modules,
    get_vgg3_11_modules,
    get_vgg3_13_modules,
    get_vgg3_16_modules,
    get_vgg3_19_modules
)
from .mlp import (
    get_mlp_modules, get_deep_mlp_modules, get_wide_mlp_modules,
    get_pinchetti_mlp_modules, get_goemaere_mlp_modules, get_goemaere_deep_mlp_modules,
    get_salvatori_mlp_modules, get_goemaere_mlp_with_sigmoid_modules, get_custom_mlp_modules
)
from .cnn import get_shallow_cnn_modules, get_deep_cnn_modules, get_wide_cnn_modules

__all__ = [
    # ResNet
    'get_resnet18_modules',
    'get_resnet34_modules',
    'get_resnet50_modules',
    
    # VGG
    'get_vgg5_modules',
    'get_vgg7_modules',
    'get_vgg9_modules',
    'get_vgg11_modules',
    'get_vgg13_modules', 
    'get_vgg16_modules',
    'get_vgg19_modules',
    
    # VGG2 (Classic VGG with pooling at the end of each block)
    'get_vgg2_5_modules',
    'get_vgg2_7_modules',
    'get_vgg2_9_modules',
    'get_vgg2_11_modules',
    'get_vgg2_13_modules',
    'get_vgg2_16_modules',
    'get_vgg2_19_modules',
    
    # VGG3 (Pooling at the beginning of each block)
    'get_vgg3_5_modules',
    'get_vgg3_7_modules',
    'get_vgg3_9_modules',
    'get_vgg3_11_modules',
    'get_vgg3_13_modules',
    'get_vgg3_16_modules',
    'get_vgg3_19_modules',
    
    # Generic MLP
    'get_mlp_modules',
    'get_deep_mlp_modules',
    'get_wide_mlp_modules',
    
    # Paper-specific MLP
    'get_pinchetti_mlp_modules',
    'get_goemaere_mlp_modules',
    'get_goemaere_deep_mlp_modules',
    'get_salvatori_mlp_modules',
    'get_goemaere_mlp_with_sigmoid_modules',
    'get_custom_mlp_modules',
    
    # CNN
    'get_shallow_cnn_modules',
    'get_deep_cnn_modules',
    'get_wide_cnn_modules',
]
