# Score-based generative modeling

Code for score-based generative modeling experiments.

## Motivation 
In DLA, we need to obtain gradients of functions U and V.
This includes the score `grad_x log(V(x))`, which we can obtain via a normalizing flow.
The other option is to learn the score with a score network.
We explore this idea here.

## Intended use
The point is to replace methods that compute `grad_x log(V(x))` with a score network.
Sampling is currently not supported (we can implement it later).

## Reading
* Score-Based Generative Modeling through Stochastic Differential Equations, https://arxiv.org/abs/2011.13456
* Denoising Score-Matching for Uncertainty Quantification in Inverse Problems, https://arxiv.org/abs/2011.08698
* Score-based Generative Modeling in Latent Space, https://arxiv.org/abs/2106.05931

