# Deterministic Langevin Monte Carlo with Normalizing Flows

Implementation of DLMC with NF. Takes as input a log likelihood and log prior function, along with a set of prior samples. Supports PyTorch and Jax backends for autodiff.

Example usage:

```
import nfmc_jax
from nfmc_jax.DLA.posterior import TorchPosterior
from nfmc_jax.DLA.base import LatentDLA, RegularDLA, NFMH, PPDLMC
from nfmc_jax.flows.base import SINFInterface

import torch

def log_likelihood(params):
  # PyTorch function that returns log likelihood.
  ...
  return log_likelihood
  
def log_prior(params):
  # PyTorch function that returns log prior
  ...
  return log_prior
  
def prior_rvs(N):
  # Draw some prior samples
  ...
  return prior_samples
  
initial_samples = prior_rvs(N)
  
posterior = TorchPosterior(log_likelihood = lambda x: log_like(x),
                           log_prior = lambda x: log_prior(x))
                           
flow_interface = SINFInterface()
flow_interface.create_flow(x=initial_samples,
                           val_frac=0.2,
                           iteration=None,
                           alpha=(0.0, 0.98),
                           NBfirstlayer=True,
                           M=None,
                           maxknot=True,
                           MSWD_max_iter=None)
                           
# Create DLMC object with LatentDLA, RegularDLA, NFMH or PPDLMC ...
dlmc = LatentDLA(interface=flow_interface,
                 burnin_interface=flow_interface,
                 posterior=posterior)

dlmc.run(**run_args)
```
