import networkx as nx
import matplotlib.pyplot as plt
from sklearn.manifold import TSNE
import numpy as np
G = nx.Graph()

# Add nodes and edges to the graph
G.add_nodes_from([1, 2, 3, 4])
G.add_edges_from([(1, 2, {'weight': 3}), (2, 3, {'weight': 2}), (3, 4, {'weight': 1})])

# Create a dictionary to store node positions
pos = {}

# Use the TSNE function to reduce the dimensionality of the graph
node_positions = TSNE(n_components=2).fit_transform(np.array(list(G.nodes())).reshape(-1, 1))

# Store the positions in the dictionary
for i, node in enumerate(G.nodes()):
    pos[node] = node_positions[i]

# Draw the graph
nx.draw(G, pos, with_labels=True, node_color='lightblue', edge_color='gray', width=[d['weight']*0.1 for (u,v,d) in G.edges(data=True)])
plt.show()
