#!/bin/bash
set -e

# Configuration
CONFIG_FILE="${CONFIG_FILE:-config.yaml}"
[ -f ".env" ] && source .env

# Parse configuration
eval $(python -c "
import yaml
with open('$CONFIG_FILE') as f:
    config = yaml.safe_load(f)
print(f\"MODEL_PATH='{config['model']['path']}'\")
print(f\"SCREENSPOT_IMGS='{config['data']['screenspot_imgs']}'\")
print(f\"SCREENSPOT_TEST='{config['data']['screenspot_test']}'\")
print(f\"CUDA_DEVICE={config['model']['cuda_device']}\")
")

# Run
mkdir -p outputs/logs
LOG_NAME="baseline-$(date +%Y%m%d-%H%M%S)"

CUDA_VISIBLE_DEVICES="$CUDA_DEVICE" \
TOKENIZERS_PARALLELISM=false \
python src/lenovo_eval_ss_pro.py \
    --model_path "$MODEL_PATH" \
    --screenspot_imgs "$SCREENSPOT_IMGS" \
    --screenspot_test "$SCREENSPOT_TEST" \
    --log_name "$LOG_NAME" \
    --root_path outputs \
    2>&1 | tee "outputs/logs/${LOG_NAME}.log"