#!/bin/bash
set -e

# Configuration
CONFIG_FILE="${CONFIG_FILE:-config.yaml}"
[ -f ".env" ] && source .env

# Parse configuration
eval $(python -c "
import yaml, os
with open('$CONFIG_FILE') as f:
    config = yaml.safe_load(f)
print(f\"MODEL_PATH='{config['model']['path']}'\")
print(f\"SCREENSPOT_IMGS='{config['data']['screenspot_imgs']}'\")
print(f\"SCREENSPOT_TEST='{config['data']['screenspot_test']}'\")
print(f\"CUDA_DEVICE={config['model']['cuda_device']}\")
print(f\"TASK='{config['data']['task']}'\")
print(f\"LANGUAGE='{config['data']['language']}'\")
print(f\"GT_TYPE='{config['data']['gt_type']}'\")
print(f\"INST_STYLE='{config['data']['inst_style']}'\")
gpt_key = config['pipeline']['gpt']['api_key']
if gpt_key == 'PLACEHOLDER_YOUR_API_KEY_HERE':
    gpt_key = os.environ.get('OPENROUTER_API_KEY', os.environ.get('OPENAI_API_KEY', ''))
print(f\"GPT_API_KEY='{gpt_key}'\")
print(f\"GPT_BASE_URL='{config['pipeline']['gpt']['base_url']}'\")
print(f\"GPT_MODEL='{config['pipeline']['gpt']['model']}'\")
")

# Run
mkdir -p outputs/logs
LOG_NAME="reground-gpt-$(date +%Y%m%d-%H%M%S)"

CUDA_VISIBLE_DEVICES="$CUDA_DEVICE" \
TOKENIZERS_PARALLELISM=false \
python src/lenovo_eval_ss_pro.py \
    --model_path "$MODEL_PATH" \
    --screenspot_imgs "$SCREENSPOT_IMGS" \
    --screenspot_test "$SCREENSPOT_TEST" \
    --task "$TASK" \
    --language "$LANGUAGE" \
    --gt_type "$GT_TYPE" \
    --inst_style "$INST_STYLE" \
    --use_reground_judge_two_images \
    --gpt_api_key "$GPT_API_KEY" \
    --gpt_base_url "$GPT_BASE_URL" \
    --gpt_model "$GPT_MODEL" \
    --log_name "$LOG_NAME" \
    --root_path outputs \
    --resume \
    2>&1 | tee "outputs/logs/${LOG_NAME}.log"