# ManiCoG Quick Start

## Setup 

```bash
# 1. Environment
conda env create -f ManiCoG_env.yml
conda activate ManiCoG
pip install -e .

# 2. Configuration
cp config.template.yaml config.yaml
# Edit paths and API key in config.yaml

# 3. Run
./run_experiment.sh      # Baseline
./run_reground_gpt.sh   # ReGrounding + GPT
```

## Required Configuration

Edit `config.yaml`:
```yaml
model:
  path: "./models/TianXi_Action_Grounding_7B"

data:
  screenspot_imgs: "./data/ScreenSpot-Pro/images"
  screenspot_test: "./data/ScreenSpot-Pro/annotations"

pipeline:
  gpt:
    api_key: "your-api-key"  # For ReGrounding+GPT
```

## Results

Output files in `./outputs/`:
- `{method}-{timestamp}.json` - Metrics
- `logs/{method}-{timestamp}.log` - Logs
- `{method}-{timestamp}.state.json` - Resume state

## Common Tasks

```bash
# Use environment variable for API key
export OPENROUTER_API_KEY="your-key"
./run_reground_gpt.sh

# Select GPU
# Edit config.yaml: model.cuda_device: 1

# Resume interrupted run
./run_reground_gpt.sh  # Auto-resumes
```

## Documentation

- [README.md](README.md) - Overview
- [CONFIG.md](CONFIG.md) - Configuration
- [INSTALL.md](INSTALL.md) - Installation