# ManiCoG Visualization (Scatter / Heatmap / Animation)

Aggregate a vision-language model’s point predictions on GUI images via multi-occlusion sampling into scatter plots and heatmaps. The script supports random sampling from an evaluation log or running on a single image with an instruction.

- Entry script: [MPD.py](MPD.py)
- Example runner script: [run_MPD.sh](run_MPD.sh)

Core functions:
- Main pipeline (collect and save): [`visualize_model_attention_points`](MPD.py)
- Per-sample processing: [`process_sample`](MPD.py)
- Random sampling: [`random_select_samples`](MPD.py)
- Plotting utilities: [`save_scatter_figure`](MPD.py), [`save_heatmap_figure`](MPD.py), [`save_overlay_figure`](MPD.py)
- Annotation helpers: [`get_bbox_from_sample`](MPD.py), [`draw_bbox`](MPD.py)

## Dependencies

- Python 3.10+
- requirements.txt

Install:
```bash
pip install -r requirements.txt
```

## Input Data

Two modes:

1) Evaluation log (recommended)
- JSON file, supports two structures:
  - An object with a `details` list
  - A list directly
- Each item should contain at least:
  - img_path: image filepath
  - prompt_to_evaluate: instruction text
  - Optional: id, correctness in {"correct","wrong"}, bbox: [x_min, y_min, x_max, y_max]

2) Single image with instruction
- Pass `--image_path` and `--instruction` via CLI

## Quick Start

- Randomly sample from an evaluation log (see the example script)
```bash
bash run_MPD.sh
```
See [run_MPD.sh](run_MPD.sh). Core command:
```bash
HF_ENDPOINT=https://hf-mirror.com python MPD.py \
  --model_type tianxi-7b \
  --filename tianxi-7b-baseline \
  --log_path ./results/tianxi-7b-baseline.json \
  --output_dir ./visual_results/tianxi-7b-baseline \
  --num_iterations 300 \
  --show_both \
  --use_block_heatmap \
  --point_size 1 \
  --block_size 100 \
  --colormap jet \
  --grid_m 20 --grid_n 10 \
  --random_pick --sample_scope wrong --random_seed 42 --num_samples 50
```

- Run on a single image and instruction
```bash
python MPD.py \
  --model_type tianxi-7b \
  --image_path /path/to/image.png \
  --instruction "Click the 'OK' button" \
  --output_dir ./visual_results/single \
  --filename demo \
  --num_iterations 300 \
  --grid_m 20 --grid_n 10 \
  --use_block_heatmap --block_size 100 --colormap jet \
  --show_both
```

## Key Arguments

- Sampling & occlusion
  - --num_iterations: number of iterations (each picks several random occlusion blocks)
  - --grid_m / --grid_n: occlusion grid rows/cols
  - --min_blocks / --max_blocks: min/max blocks per iteration
- Visualization
  - --use_scatter: scatter only (default is heatmap)
  - --show_both: show original + scatter + heatmap triptych
  - --point_size: scatter dot size
  - --alpha: heatmap alpha
  - --colormap: color map, e.g., jet, coolwarm, RdBu, bwr, hot, viridis
- Block heatmap
  - --use_block_heatmap: block-count-based heatmap (instead of KDE)
  - --block_size: fixed pixel size (auto-estimated if not set)
  - --min_heatmap_blocks / --max_heatmap_blocks: bounds for auto block size estimation
- Random sampling (log mode)
  - --random_pick: enable random sampling
  - --sample_scope: correct | wrong | all
  - --random_seed: RNG seed
  - --num_samples: number of samples to select

## Outputs

For each sample (if enough points are collected):
- Scatter: ..._scatter.png (yellow points)
- Heatmap: ..._heatmap.png (KDE or block heatmap)
- Overlay: ..._overlay.png (green bbox + red base point)

File naming:
- Prefix `[{filename}_]{safe_id}_{correct|wrong}`
- safe_id comes from sample id or image name (sanitized)
- Optional points JSON (--save_points): points/xxx_points.json

## Pipeline

- Occlusion sampling and point collection: [`visualize_model_attention_points`](MPD.py)
  - Obtain a base prediction on the full image (red point)
  - Run multiple random occluded predictions and accumulate valid points
  - Output scatter, heatmap, overlay, and point set
- Animation generation: [`generate_accumulation_animation`](MPD.py)
  - Increase iterations per frame to visualize accumulation
- Per-sample wrapper: [`process_sample`](MPD.py)
- Random sampling: [`random_select_samples`](MPD.py)

## Log Schema

Each item should include:
- img_path, prompt_to_evaluate
- Optional: id, correctness, bbox

The script auto-detects either an object with a `details` list or