#!/bin/bash
set -e
export CUDA_VISIBLE_DEVICES=1
export TOKENIZERS_PARALLELISM=false  
# English
model_type=tianxi-7b
HF_ENDPOINT=https://hf-mirror.com python MPD.py \
  --model_type ${model_type} \
  --filename ${model_type}-baseline \
  --log_path ./results/${model_type}-baseline.json \
  --output_dir ./visual_results/${model_type}-baseline \
  --num_iterations 300 \
  --show_both \
  --use_block_heatmap \
  --point_size 1 \
  --block_size 100 \
  --colormap jet \
  --grid_m 20 \
  --grid_n 10 \
  --random_pick \
  --sample_scope wrong \
  --random_seed 42 \
  --num_samples 50
