from setuptools import setup, find_packages
import os

# Read the contents of README file
this_directory = os.path.abspath(os.path.dirname(__file__))
with open(os.path.join(this_directory, 'README.md'), encoding='utf-8') as f:
    long_description = f.read()

# Core requirements - minimal set for basic functionality
requirements = [
    "torch>=2.0.0",
    "transformers>=4.40.0", 
    "Pillow>=10.0.0",
    "numpy>=1.24.0",
    "tqdm>=4.65.0",
    "omegaconf>=2.3.0",
    "pyyaml>=6.0.0",
    "openai>=1.0.0",
    "requests>=2.28.0",
    "matplotlib>=3.7.0",
    "opencv-python>=4.8.0",
    "accelerate>=0.20.0",
    "tensorboard>=2.14.0",
    "datasets>=2.14.0",
    "scikit-learn>=1.3.0",
    "pandas>=2.0.0"
]

setup(
    name="manicog",
    version="1.0.0",
    author="ManiCoG Contributors",
    author_email="",
    description="Multi-modal GUI grounding framework with iterative refinement",
    long_description=long_description,
    long_description_content_type="text/markdown",
    packages=find_packages(where="src"),
    package_dir={"": "src"},
    classifiers=[
        "Development Status :: 4 - Beta",
        "Intended Audience :: Science/Research",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9", 
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Topic :: Scientific/Engineering :: Artificial Intelligence",
    ],
    python_requires=">=3.8",
    install_requires=requirements,
    extras_require={
        "dev": [
            "pytest>=7.0.0",
            "pytest-cov>=4.0.0",
            "black>=23.0.0",
            "isort>=5.12.0",
            "flake8>=6.0.0",
            "mypy>=1.4.0",
        ],
        "full": [
            "flash-attn>=2.5.0",
            "bitsandbytes>=0.41.0",
            "jupyter>=1.0.0",
            "seaborn>=0.12.0",
            "wandb>=0.16.0",
        ]
    },
    entry_points={
        "console_scripts": [
            "manicog-eval=lenovo_eval_ss_pro:main",
        ],
    },
    include_package_data=True,
    keywords=[
        "gui grounding", "multimodal", "vision-language", 
        "human-computer interaction", "ui automation"
    ],
)