#!/bin/bash
set -x
nnodes=1
nproc_per_node=8
node_rank=0
xxxxxx="127.0.0.1"
master_port=29502
port=29502
# xxxx

for beta in 0.02; do
    expid="cond_class_beta${beta}_biasedNCA_384L_negw1.0_dropout_uncondmax"
    torchrun \
        --nnodes=$nnodes --nproc_per_node=$nproc_per_node --node_rank=$node_rank \
        --xxxxxx=$xxxxxx --master_port=$port \
        autoregressive/train/finetune_c2i.py --global-batch-size 256 --gradient-accumulation-step 2 \
        --normalizing-axes "class" --beta ${beta} --expid $expid \
        --epochs 1 --ckpt-every 5000 --lr 1e-5 --loss-type "biasedNCA" --negw 1.0 \
        --rolling-permute --mask-index-ratio 0.1 --keep_dropout \
        --ref-ckpt /safasfafasfasa/xxxxxx/LlamaGen/c2i_L_384.pt \
        --code-path /safasfafasfasa/xxxxxx/imagenet384_train_code_c2i_flip_ten_crop/ \
        --image-size 384 --gpt-model GPT-L
    port=$((port + 1))
done




