import os
import re

# 设置输入和输出的文件夹路径
input_dir = './'
output_dir = '../samples'

# 获取文件夹中所有txt文件
txt_files = [f for f in os.listdir(input_dir) if f.endswith('.npz.txt')]

# 定义要搜索的模式
patterns = [
    r"Inception Score: ([\d.]+)",
    r"FID: ([\d.]+)",
    r"sFID: ([\d.]+)",
    r"Precision: ([\d.]+)",
    r"Recall: ([\d.]+)"
]

for filename in txt_files:
    file_path = os.path.join(input_dir, filename)
    output_file_path = os.path.join(output_dir, filename[:-8] + '.txt')
    
    # 检查输出文件是否已存在
    if os.path.exists(output_file_path):
        continue
    
    with open(file_path, 'r') as file:
        content = file.read()
        
        matches = []
        for pattern in patterns:
            match = re.search(pattern, content)
            if match:
                matches.append(match.group(0))
        
        # 如果没有找到任何匹配，跳过写入
        if not matches:
            continue
        
        # 写入匹配到的数据到输出文件
        with open(output_file_path, 'w') as output_file:
            output_file.write('\n'.join(matches))

print("处理完成。")
