
## Training

The following is an example of model training on the RefCOCOg dataset.
```
python -m torch.distributed.launch --nproc_per_node=4 --use_env train.py --config configs/Highlighter_R50_gref_umd.py
```
We train the model on 2 GPUs with a total batch size of 64 for 90 epochs. 
The model and training hyper-parameters are defined in the configuration file ``Highlighter_R50_gref_umd.py``. 
We will prepare the configuration files for different datasets in the ``configs/`` folder. 

## Evaluation
Run the following script to evaluate the trained model with a single GPU.
```
python test.py --config configs/Highlighter_R50_gref_umd.py --checkpoint Highlighter_R50_gref.pth --batch_size_test 16 --test_split val
```
Or evaluate the trained model with 4 GPUs:
```
python -m torch.distributed.launch --nproc_per_node=4 --use_env test.py --config configs/Highlighter_R50_gref_umd.py --checkpoint Highlighter_R50_gref.pth --batch_size_test 16 --test_split val
```

## Acknowledgement
Part of our code is based on the previous works [VLTVG](https://github.com/yangli18/VLTVG), [DETR](https://github.com/facebookresearch/detr) and [ReSC](https://github.com/zyang-ur/ReSC).