#!/bin/bash

version="0.1"

# This is an optional arguments-only example of Argbash potential
#
# ARG_OPTIONAL_SINGLE([path],[p],[path onto which files are to be downloaded],[data])
# ARG_VERSION([echo test v$version])
# ARG_HELP([The general script's help msg])
# ARGBASH_GO()
# needed because of Argbash --> m4_ignore([
### START OF CODE GENERATED BY Argbash v2.5.0 one line above ###
# Argbash is a bash code generator used to get arguments parsing right.
# Argbash is FREE SOFTWARE, see https://argbash.io for more info
# Generated online by https://argbash.io/generate

die()
{
    local _ret=$2
    test -n "$_ret" || _ret=1
    test "$_PRINT_HELP" = yes && print_help >&2
    echo "$1" >&2
    exit ${_ret}
}

begins_with_short_option()
{
    local first_option all_short_options
    all_short_options='pvh'
    first_option="${1:0:1}"
    test "$all_short_options" = "${all_short_options/$first_option/}" && return 1 || return 0
}



# THE DEFAULTS INITIALIZATION - OPTIONALS
_arg_path="referit_data"

print_help ()
{
    printf "%s\n" "download ReferIt data script"
    printf 'Usage: %s [-p|--path <arg>] [-v|--version] [-h|--help]\n' "$0"
    printf "\t%s\n" "-p,--path: path onto which files are to be downloaded (default: '"referit_data"')"
    printf "\t%s\n" "-v,--version: Prints version"
    printf "\t%s\n" "-h,--help: Prints help"
}

parse_commandline ()
{
    while test $# -gt 0
    do
        _key="$1"
        case "$_key" in
            -p|--path)
                test $# -lt 2 && die "Missing value for the optional argument '$_key'." 1
                _arg_path="$2"
                shift
                ;;
            --path=*)
                _arg_path="${_key##--path=}"
                ;;
            -p*)
                _arg_path="${_key##-p}"
                ;;
            -v|--version)
                echo test v$version
                exit 0
                ;;
            -v*)
                echo test v$version
                exit 0
                ;;
            -h|--help)
                print_help
                exit 0
                ;;
            -h*)
                print_help
                exit 0
                ;;
            *)
                _PRINT_HELP=yes die "FATAL ERROR: Got an unexpected argument '$1'" 1
                ;;
        esac
        shift
    done
}

parse_commandline "$@"

# OTHER STUFF GENERATED BY Argbash

### END OF CODE GENERATED BY Argbash (sortof) ### ])
# [ <-- needed because of Argbash


echo "Save data to: $_arg_path"


REFERIT_SPLITS_URL="https://s3-sa-east-1.amazonaws.com/query-objseg/referit_splits.tar.bz2"
REFERIT_DATA_URL="http://www.eecs.berkeley.edu/~ronghang/projects/cvpr16_text_obj_retrieval/referitdata.tar.gz"
COCO_DATA_URL="http://images.cocodataset.org/zips/train2014.zip"

REFCOCO_URL="http://bvisionweb1.cs.unc.edu/licheng/referit/data/refcoco.zip"
REFCOCO_PLUS_URL="http://bvisionweb1.cs.unc.edu/licheng/referit/data/refcoco+.zip"
REFCOCOG_URL="http://bvisionweb1.cs.unc.edu/licheng/referit/data/refcocog.zip"

REFERIT_FILE=${REFERIT_DATA_URL#*cvpr16_text_obj_retrieval/}
SPLIT_FILE=${REFERIT_SPLITS_URL#*query-objseg/}
COCO_FILE=${COCO_DATA_URL#*zips/}


if [ ! -d $_arg_path ]; then
    mkdir $_arg_path
fi
cd $_arg_path

mkdir referit
cd referit

printf "Downloading ReferIt dataset (This may take a while...)"
aria2c -x 8 $REFERIT_DATA_URL


printf "Uncompressing data..."
tar -xzvf $REFERIT_FILE
rm $REFERIT_FILE

mkdir splits
cd splits

printf "Downloading ReferIt Splits..."
aria2c -x 8 $REFERIT_SPLITS_URL

tar -xjvf $SPLIT_FILE
rm $SPLIT_FILE

cd ../..

mkdir -p other/images/mscoco/images
cd other/images/mscoco/images

printf "Downloading MS COCO 2014 train images (This may take a while...)"
aria2c -x 8 $COCO_DATA_URL

unzip $COCO_FILE
rm $COCO_FILE

cd ../../..
printf "Downloading refcoco, refcocog and refcoco+ splits..."
aria2c -x 8 $REFCOCO_URL
aria2c -x 8 $REFCOCO_PLUS_URL
aria2c -x 8 $REFCOCOG_URL

unzip "*.zip"
rm *.zip