import numpy as np
# VGG-16 for CIFAR-10
vgg16_cifar10 = [
    0.04938271604938271,
    0.0023148148148148147,
    0.0023148148148148147,
    0.0011574074074074073,
    0.0011574074074074073,
    0.0005787037037037037,
    0.0005787037037037037,
    0.0005787037037037037,
    0.00028935185185185187,
    0.00028935185185185187,
    0.00028935185185185187,
    0.00028935185185185187,
    0.00028935185185185187,
    0.0026041666666666665,
    0.0026041666666666665,
    0.0026041666666666665,
]

# VGG-16 for CIFAR-100 (only FC3 differs)
vgg16_cifar100 = vgg16_cifar10[:-1] + [0.0026041666666666665]

# VGG-16 for ImageNet (input flattened to 25088)
vgg16_imagenet = [
    0.04938271604938271,
    0.0023148148148148147,
    0.0023148148148148147,
    0.0011574074074074073,
    0.0011574074074074073,
    0.0005787037037037037,
    0.0005787037037037037,
    0.0005787037037037037,
    0.00028935185185185187,
    0.00028935185185185187,
    0.00028935185185185187,
    0.00028935185185185187,
    0.00028935185185185187,
    0.000052083333333333336,  # FC1
    0.0003255208333333333,    # FC2
    0.0003255208333333333,    # FC3
]

# ResNet-18 for CIFAR-10
resnet18_cifar10 = [
    0.004629629629629629,     # Conv1 (3x3)
    0.0005787037037037037,    # Block1_1
    0.0005787037037037037,    # Block1_2
    0.00028935185185185187,   # Block2_1
    0.00028935185185185187,   # Block2_2
    0.00014467592592592593,   # Block3_1
    0.00014467592592592593,   # Block3_2
    7.233796296296296e-05,    # Block4_1
    7.233796296296296e-05,    # Block4_2
    0.0026041666666666665,    # FC
]

# ResNet-18 for CIFAR-100 (FC layer differs)
resnet18_cifar100 = resnet18_cifar10[:-1] + [0.0026041666666666665]

# ResNet-34 for ImageNet
resnet34_imagenet = [
    0.006172839506172839,  # Conv1 (7x7)
    *[0.0005787037037037037] * 3,     # Block1
    *[0.00028935185185185187] * 4,    # Block2
    *[0.00014467592592592593] * 6,    # Block3
    *[7.233796296296296e-05] * 3,     # Block4
    0.0026041666666666665,           # FC
]

def ratio(r1, T):
    r = (1+(5*T-2)*r1)/(1+T*r1)
    return r

Tarr =[16, 16, 16, 8, 16, 8, 16, 8, 16, 8, 16, 8, 16, 8, 16, 8, 16, 8, 16, 8, 16, 8, 16, 8, 16, 8, 16, 8, 8, 8, 8, 8, 8]
retval = [ratio(x,T)*T for (x,T) in zip(resnet34_imagenet,Tarr)]
print(retval)
print(np.array(retval).mean())
