# Demo

A demo for Acc-SVRG-G proposed in "Practical Schemes for Finding Near-Stationary Points of Convex Finite-Sums".

## Usage

All algorithms are implemented in C++.

To run the demo in MATLAB, first run `mex_all` in the MATLAB terminal to generate the mex file. (Note that the compiler should support at least `c++11`)

Then, run `TEST` in the MATLAB terminal, a small demo training logistic regression using dataset `a9a` from [LIBSVM Data](https://www.csie.ntu.edu.tw/~cjlin/libsvmtools/datasets/), to generate a plot shown as below.

Test environment: Macbook Pro with a quad-core Intel Core i7-4870HQ with 2.50GHz cores, 16GB RAM, macOS Big Sur with Clang 12.0.5 and MATLAB R2020b.

![](SAMPLE.png)

```bash
>> TEST
Building with 'Xcode Clang++'.
MEX completed successfully.
Model: L2-logistic
Algorithm: L2S, Seeds: 1
Time: 3.114522 seconds 
Algorithm: L2S, Seeds: 2
Time: 2.544477 seconds 
Algorithm: L2S, Seeds: 3
Time: 2.526142 seconds 
Algorithm: L2S, Seeds: 4
Time: 2.530117 seconds 
Algorithm: L2S, Seeds: 5
Time: 2.531847 seconds 
Algorithm: L2S, Seeds: 1
Time: 2.589740 seconds 
Algorithm: L2S, Seeds: 2
Time: 2.535341 seconds 
Algorithm: L2S, Seeds: 3
Time: 2.529283 seconds 
Algorithm: L2S, Seeds: 4
Time: 2.732937 seconds 
Algorithm: L2S, Seeds: 5
Time: 2.764189 seconds 
Algorithm: Acc_SVRG_G, Seeds: 1
Time: 2.765892 seconds 
Algorithm: Acc_SVRG_G, Seeds: 2
Time: 2.800313 seconds 
Algorithm: Acc_SVRG_G, Seeds: 3
Time: 2.839613 seconds 
Algorithm: Acc_SVRG_G, Seeds: 4
Time: 2.929133 seconds 
Algorithm: Acc_SVRG_G, Seeds: 5
Time: 2.864923 seconds 
```


