#ifndef GRADDESCDENSE_H
#define GRADDESCDENSE_H
#include "blackbox.hpp"

namespace grad_desc_dense {
    class outputs {
    public:
        outputs(std::vector<double>* _losses, std::vector<double>* _times):
            losses(_losses), times(_times) {}
        std::vector<double>* losses;
        std::vector<double>* times;
    };
    const int SVRG_LAST_LAST = 1;
    const int SVRG_AVER_AVER = 2;
    const int SVRG_AVER_LAST = 3;

    outputs SAGA(double* X, double* Y, int N, blackbox* model, int iteration_no
        , double step_size);
    outputs Prox_SVRG(double* X, double* Y, int N, blackbox* model, int iteration_no
        , int Mode, double L, double step_size);
    outputs L2S(double* X, double* Y, int N, blackbox* model, int iteration_no
        , double step_size);
    outputs Acc_SVRG_G(double* X, double* Y, int N, blackbox* model , int iteration_no
        , double L);
}

#endif
