
# Ad Allocation with Predictions: Experiments on Real-World and Synthetic Data

## Setup

We require numpy, pandas, and cvxpy (with GUROBI).

## Running the Experiments

Experiments can be executed in [plots.py](plots.py) by calling a function that
corresponds to an experiment. For example,
```
plot_synthetic1()
```
executes the first experiment on synthetic data and creates a plot for it.
Available experiments are:
- `plot_synthetic1`: Synthetic experiments with different predictors for varying alpha
- `plot_synthetic2`: Synthetic experiments with dual base predictors for varying alpha
- `plot_synthetic3`: Synthetic experiments for fixed alpha with varying prediction quality
- `plot_worst_case`: Experiments on worst-case instance
- `plot_real_world1`: Experiments on iPinYou dataset for different predictors and varying alpha
- `plot_real_world2`: Experiments on Yahoo dataset for different predictors and varying alpha
- `plot_real_world3`: Experiments on iPinYou dataset for fixed alpha with varying prediction quality
- `plot_real_world4`: Experiments on Yahoo dataset for fixed alpha with varying prediction quality
- `plot_gap`: Experiments on synthetic Ad Words instances

## Folder Structure

- [ipinyou.py](ipinyou.py) and [yahoo.py](yahoo.py) transform the original datasets into
  ads instances (the results are in [pickles](pickles))
- [tools.py](tools.py) contains all (online/offline) algorithms
- [plots.py](plots.py) contains all experiments and plotting functionality

## Datasets

[pickles](pickles) contains the yahoo and ipinyou instances.
These instances can be generated with the scripts [ipinyou.py](ipinyou.py) and
[yahoo.py](yahoo.py).
The iPinYou dataset is from https://contest.ipinyou.com/ and the Yahoo
dataset from https://webscope.sandbox.yahoo.com/catalog.php?datatype=a
"A3 - Yahoo! Search Marketing Advertiser Bid-Impression-Click data on competing Keywords, version 1.0".