## Prerequisites
```
$ conda env create -f py39.yaml
$ pip install cl-gym
```
For more information on the cl-gym library, refer to [imirzadeh/CL-Gym](https://github.com/imirzadeh/CL-Gym).

## Run
1. __MNIST__ experiment
```
$ bash scripts/MNIST.sh
```

2. __FashionMNIST__ experiment

```
$ bash scripts/FashionMNIST.sh
```

3. __BiasedMNIST__ experiment

```
$ bash scripts/BiasedMNIST.sh
```

4. __Drug__ experiment

```
$ bash scripts/Drug.sh
```

Need to run the command line below to load the drug dataset

```
$ pip3 install -U ucimlrepo
```


5. __BiasBios__ experiment

```
$ bash scripts/Bios.sh
```

Need to download *.pickle files first to load the bios dataset. \
You can either download bios file from (1) official repo (2) google drive (3) wget command.
```
 (1) https://github.com/Microsoft/biosbias (official repo) 
 (2) https://github.com/brcsomnath/FaRM/tree/main (containing google drive link)
 (3) mkdir -p data/biasbios
     wget https://storage.googleapis.com/ai2i/nullspace/biasbios/train.pickle -P data/biasbios/
     wget https://storage.googleapis.com/ai2i/nullspace/biasbios/dev.pickle -P data/biasbios/
     wget https://storage.googleapis.com/ai2i/nullspace/biasbios/test.pickle -P data/biasbios/
```     
Then copy `{train, test, dev}.pickle` to `{DEFAULT_DATASET_DIR}/bios` directory
where `{DEFAULT_DATASET_DIR}` of CL-Gym library is `cl_gym/data`.




## License for Optimization Solver
Both MOSEK and CPLEX optimization solvers are free for students and academics. Installing these solvers is straightforward, as you can simply follow the provided guidelines for each package.
```python
# MOSEK
https://www.mosek.com/products/academic-licenses/
https://www.mosek.com/downloads/

# CPLEX
https://community.ibm.com/community/user/datascience/blogs/xavier-nodet1/2020/07/09/cplex-free-for-students
```
