
Fix the following UCLID5 code using the compiler feedback provided below.

```

; Define enumeration type
(enum status (ready busy))

; Declare variables
(declare-const request Bool)
(declare-const status status)

; Auxiliary variable to track if request becomes true
(declare-const request_true Bool)

; Initial status is ready
(assert (= status ready))

; Property to check if eventually status becomes busy when request is true
(assert (=> request
        (=> (not (= status busy))
            (exists ((request_true_prev Bool))
                (and request_true_prev
                     (not request_true)
                     (= status busy)
                     ))))

; Check satisfiability
(check-sat)
```

Compiler feedback:

```
Syntax error on tmp.ucl, line 2: end of input expected.
; Define enumeration type

```
Reply with your UCLID5 code inside one unique code block.

I can definitely do that! Here is the UCLID5 code:
```
