# CoRT: Code-integrated Reasoning within Thinking

This repository contains the official implementation of CoRT, a post-training framework for teaching Large Reasoning Models (LRMs) to leverage Code Interpreter effectively and efficiently.

## Overview

CoRT introduces a novel approach to improve mathematical reasoning capabilities of LRMs through:
- Hint-Engineering for data synthesis
- Multi-stage training pipeline including SFT, RFT and RL
- Efficient coordination between Code Interpreter and Chain-of-Thought reasoning

## Key Features

- Data synthesis through Hint-Engineering 
- Training pipeline for both 32B and 1.5B models
- Significant improvements in both accuracy and token efficiency
- Comprehensive evaluation across 5 mathematical reasoning benchmarks

## Installation

```bash
cd cort
```

## Training Pipeline

### SFT/RFT
```bash 
sh sft_scripts/launch_sft.sh
```

### RL (Reinforcement Learning)
```bash
sh deepscaler/rl_scripts/launch_cort_rl.sh
```

## Evaluation

To evaluate trained models:

```bash
sh evaluation/eval_dp_8_tp_1_n_16_maxml_32k_maxfc_15_maxlpc_32k.sh <model_to_eval>
```