import re
import json
from collections import Counter

import importlib
from functools import lru_cache
import requests
import openai



def load_txt_data(path):
    with open(path, 'r', encoding='gb18030', errors='ignore') as f:
        data = f.readlines()
    data = [eval(sub_data) for sub_data in data]
    return data

def save_json_file(data, filename):
    with open(filename, 'w') as file:
        json.dump(data, file)

def is_openai_api_key(key):
    API_MATCH = re.match(r"sk-[a-zA-Z0-9]{48}$", key)
    return bool(API_MATCH)

def is_any_api_key(key):
    if ',' in key:
        keys = key.split(',')
        for key_ in keys:
            if is_any_api_key(key_):
                return True
        return False
    else:
        return is_openai_api_key(key)


@lru_cache(maxsize=128)
def read_single_conf_with_lru_cache(arg):
    try:
        r = getattr(importlib.import_module('config.config_private'), arg)
    except:
        r = getattr(importlib.import_module('config.config'), arg)
    # 检验api-key格式的合法性
    if arg == 'API_KEY':
        print(f'[INFO] 您可以同时填写多个api-key并用逗号分隔，例如：API_KEY=\"openai-key1,openai-key2\"')
        if is_any_api_key(r):
            print(f'[INFO] 您的API_KEY是： {r[:15]}*** API_KEY导入成功')
        else:
            print(f'[ERROR] 正确的API_KEY是"sk"开头的51位密钥，请在config_private.py或config.py文件中修改API密钥后运行')
    # 检验网络代理配置格式是否正确
    if arg == 'proxies':
        if r is None:
            print(f'[ERROR] 网络代理状态：未配置。请检查config_private.py或config.py文件中的USE_PROXY选项是否修改')
        else:
            print(f'[INFO] 网络代理状态：已配置。配置信息如下：{r}')
            assert isinstance(r, dict), 'proxies格式错误，请注意proxies选项的格式，不要遗漏括号'
    return r

def get_conf(*args):
    result = [read_single_conf_with_lru_cache(arg) for arg in args]
    return result

def check_proxy(proxies):
    proxies_https = proxies['https'] if proxies is not None else '无'
    try:
        headers = {'User-Agent': 'Mozilla/5.0 3578.98 Safari/537.36'}
        data = requests.get(f'https://ipapi.co/json/', timeout=20, headers=headers, proxies=proxies).json()
        print(f'[INFO] 查询代理的地理位置，返回结果是{data}')
        if 'country_name' in data:
            country = data['country_name']
            result = f"[INFO] 代理配置：{proxies_https}，代理所在地：{country}"
        elif 'error' in data:
            result = f"[ERROR] 代理配置：{proxies_https}，代理所在地：未知，IP查询频率受限"
        print(result)
        return result
    except:
        result = f"[ERROR] 代理配置：{proxies_https}，代理所在地查询超时，代理可能无效"
        print(result)
        return result


def get_response(key, prompt, model, max_tokens, temperature):
    openai.api_key = key

    response = openai.Completion.create(
      model=model,
      prompt=prompt,
      temperature=temperature,
      max_tokens=max_tokens,
      top_p=1,
      frequency_penalty=0,
      presence_penalty=0
    )
    results = response.get('choices')
    results = [result.get('text').replace("\n", " ").strip() for result in results]
    return results
