import os
import re
import random
import math
import time

from utils import get_conf, check_proxy, get_response


API_KEY = "***"

model_card = "text-davinci-003"
os.environ['no_proxy'] = '*'
proxies = {
    "http": "socks5h://localhost:11284",
    "https": "socks5h://localhost:11284"
}
proxy_info = check_proxy(proxies)

max_tokens = 512
temperature = 0.7


def generate_instruction(original_question, condition_sentence, problem_sentence):
    instruction_prompt = f"Q: {original_question} Is condition \"{condition_sentence}\" relevant to the process of solving problem \"{problem_sentence}\"\nA: Let's think step by step."
    instruction = get_response(
        API_KEY,
        prompt=instruction_prompt,
        model=model_card,
        max_tokens=max_tokens,
        temperature=temperature
    )[0]
    time.sleep(0.1)
    return instruction

