# -*- coding: utf-8 -*-
import warnings
warnings.filterwarnings('ignore')
import json
import os
import re

import LoadData
from Choices import data_name_choices, data_path_config
from Segment import problem_split
from Encoding import encoding_sentence
import i3c_prompt, solving_prompt


## load raw data
data_name_idx = 0 
num_demonstrations = 8
root_path = r'../dataset/'
data_name = data_name_choices[data_name_idx]
data_path_config = data_path_config.get(data_name)
data_loder = LoadData.DataLoder(root_path=root_path)
questions, equations, gold_answers = data_loder.load_data(data_path=data_path_config.get('data_path'), data_name_1=data_path_config.get('data_name_1'))
problems_have_been_solved = []

for idx in range(len(questions)):
    problem = questions[idx]
    ## condition and question splits
    conditions, question = problem_split(problem)

    ## encoding
    confusion_score, ic_candidate_index = encoding_sentence(conditions, question)

    ## I3C 
    verification_outputs = []
    for instruction_idx in ic_candidate_index:
        verification_outputs.append(i3c_prompt.generate_instruction(problem, conditions[instruction_idx], question))
    
    ## solving
    if len(verification_outputs)>=1:
        verification_outputs = '\n'.join(verification_outputs)
    else:
        verification_outputs = 'None'
    reasoning_path, numerical_answer = solving_prompt.generate_answer(
        problem,
        verification_outputs, 
        problems_have_been_solved, 
        num_demonstrations
    )
    problems_have_been_solved.append(
        {
            'problem': problem, 
            'reasoning_path': reasoning_path, 
            'numerical_answer': numerical_answer, 
            'confusion_score': confusion_score
        }
    )


