#!/bin/bash

if [ -d "../output_syn" ]; then
    rm -rf "../output_syn"
fi
if [ -d "../output_real" ]; then
    rm -rf "../output_real"
fi

if [ -d "./logs" ]; then
    rm -rf "./logs"
fi

mkdir -p logs

# run 20 exp_syn1.py
for i in {1..20}
do
    python exp_syn1.py --task_id $i > logs/syn1_${i}.log 2>&1 &
done

# run 20 exp_syn2.py
for i in {1..20}
do
    python exp_syn2.py --task_id $i > logs/syn2_${i}.log 2>&1 &
done

# run 25 exp_real.py
for i in {1..25}
do
    python exp_real.py $i "../real_data/movielens.csv" "../output_real" "real_example_movielens" 2 30 > logs/real_movielens_${i}.log 2>&1 &
done

# run 25 exp_real.py
for i in {1..25}
do
    python exp_real.py $i "../real_data/yelp.csv" "../output_real" "real_example_yelp" 2 30 > logs/real_yelp_${i}.log 2>&1 &
done

wait
echo "All training scripts finished."