import functools
from shift_match import make_resnet20_frn_fn
import haiku as hk
from absl import flags
from tqdm.notebook import tqdm
from bnn_hmc.utils import data_utils
from bnn_hmc.utils import precision_utils
from bnn_hmc.utils import metrics
from bnn_hmc.utils import models
from jax import vmap
from jax.interpreters import xla
from jax import lax
from jax.random import normal, PRNGKey, split
import numpy as onp
from jax import numpy as jnp
from bnn_hmc.utils import checkpoint_utils
from matplotlib import pyplot as plt
import seaborn as sns
import matplotlib
import jax
import sys
import tensorflow_datasets as tfds
import os
import pickle
os.environ['XLA_PYTHON_CLIENT_PREALLOCATE'] = 'false'
os.environ['TF_FORCE_GPU_ALLOW_GROWTH'] = 'true'
os.environ['XLA_PYTHON_CLIENT_ALLOCATOR'] = 'platform'


sys.path.append("google-research/")
log_dir = '/home/ooo123/data/sm_sgd_result_log'

def get_params_and_state_sgd(seed):
  # sgd_base_dir = f'/home/ooo123/data/sgd_log/seed{seed}'
  # ckpt_dir = os.path.join(sgd_base_dir, 'model_step_499.pt')
  sgd_base_dir = ('/home/ooo123/data/sgd_log_aug/' +
                  f'sgd_mom_0.9__lr_sch_i_1e-06___epochs_200_wd_0.0001_batchsize_80_temp_1.0__seed_{seed}')
  ckpt_dir = os.path.join(sgd_base_dir, 'model_step_199.pt')
  ckpt_dict = checkpoint_utils.load_checkpoint(ckpt_dir)
  params = ckpt_dict["params"]
  net_state = ckpt_dict["net_state"]
  # params = jax.tree_map(lambda p: p[chain_id], params)
  # net_state = jax.tree_map(lambda p: p[chain_id], net_state)
  return params, net_state


_DEFAULT_BN_CONFIG = {
    "decay_rate": 0.9,
    "eps": 1e-5,
    "create_scale": True,
    "create_offset": True
}


def normalization_layer():
  return hk.BatchNorm(**_DEFAULT_BN_CONFIG)


shift_match_config = {
    'feature_only': False,
    'shift_match_before_act': True
}
cache_dir = '/home/ooo123/data/sm_sgd_cov_cache'
train_set, _, _ = data_utils.load_image_dataset('train', 5000, 'cifar10')

for seed in tqdm(range(200, 500, 10)):
  x = normal(PRNGKey(0), (10, 32, 32, 3))
  y = jnp.ones_like(x)

  net_init, net_apply = hk.transform_with_state(
      make_resnet20_frn_fn('channel_wise_sep_cov_mean', normalization_layer=normalization_layer,
                          activation=jax.nn.relu)
  )
  params, init_state = net_init(PRNGKey(0), batch=x, is_training=True, shift_match_mode=None,
                                **shift_match_config)
  params, state_bn = get_params_and_state_sgd(seed)
  state_w_bn = {}
  state_wo_bn = {}
  for k, v in init_state.items():
    if k in state_bn:
      state_w_bn[k] = state_bn[k]
      state_wo_bn[k] = state_bn[k]
    else:
      state_w_bn[k] = init_state[k]
      state_wo_bn[k] = init_state[k]
  for x, y in tqdm(train_set):
    _, state_w_bn = net_apply(params, state_w_bn, None, x, True, 'acc', **shift_match_config)
    _, state_wo_bn = net_apply(params, state_wo_bn, None, x, False, 'acc', **shift_match_config)
  with open(os.path.join(cache_dir, f"bn_sm__{seed}.pkl"), "wb") as f:
    pickle.dump(state_w_bn, f)
  with open(os.path.join(cache_dir, f"sm_{seed}.pkl"), "wb") as f:
    pickle.dump(state_wo_bn, f)