import csv

def process_csv(input_file_path, output_file_path):
    who_set = set()

    # 读取CSV文件并将所有"Suing Who"列的单词添加到集合中
    with open(input_file_path, 'r', encoding='utf-8') as infile:
        reader = csv.DictReader(infile)
        for row in reader:
            who_set.add(row['Who'])
            who_set.add(row['Suing Who'])

    # 去除重复项并写入新的CSV文件
    with open(output_file_path, 'w', newline='', encoding='utf-8') as outfile:
        writer = csv.writer(outfile)
        writer.writerow(['Who'])
        for who in who_set:
            writer.writerow([who])

# 使用示例
input_file_path = './document/basic_understanding/topic_words_key_words.csv'
output_file_path = './document/basic_understanding/processed_topic_words.csv'
process_csv(input_file_path, output_file_path)