import json
import matplotlib.pyplot as plt
import numpy as np

def load_json(file_path):
    with open(file_path, 'r') as file:
        content = file.read()
    return json.loads(content)

data = load_json('/Users/wad3/Downloads/paper/visual_autobench/document/atmospheric_understanding/aligned_image_json/easy_aligned_images.json')
scores = [item['score'] for item in data if item['score'] != 0]
average_score = np.mean(scores)
# print(len(scores))
# print(average_score)
# print(scores)

plt.figure(figsize=(10, 6))
plt.hist(scores, bins=20, color='skyblue', edgecolor='black')
plt.title('distribution')
plt.xlabel('score')
plt.ylabel('times')
plt.grid(True)
# plt.show()

# 计算每个分数段的占比
score_segments = [0] * 5
for score in scores:
    # print(score)
    if score <= 0.2:
        score_segments[0] += 1
    elif score <= 0.4:
        score_segments[1] += 1
    elif score <= 0.6:
        score_segments[2] += 1
    elif score <= 0.8:
        score_segments[3] += 1
    else:
        score_segments[4] += 1

# print(score_segments)
score_segments = [segment / len(scores) for segment in score_segments]
print(score_segments)



