# Layout Transformer

This is the official Pytorch implementation of *LayoutTransformer: Relation-Aware Scene Layout Generation*

## Getting Started

### 1. Packages
```bash
$ pip install transformers
$ pip install coloredlogs
$ pip install bounding_box
```

### 2. Datasets
1. Download the MSCOCO Dataset : [[1]](http://images.cocodataset.org/annotations/annotations_trainval2017.zip) [[2]](http://images.cocodataset.org/annotations/stuff_annotations_trainval2017.zip)
2. Download the VG-MSDN Dataset: [[1]](https://drive.google.com/file/d/1WjetLwwH3CptxACrXnc1NCcccWUVDO76/view)
3. Please put the COCO dataset in ./data/coco and put VG-MSDN dataset in ./data/vg_msdn
4. Take COCO for example, you will find important data files such as instances_train2017.json, instances_val2017.json and stuff_train2017.json in ./data/coco.

### 3. File Path
```
.
├── data/
	└── coco/
	    ├── train2017/
	    ├── val2017/
	    └── .json annotation files
├── loader/
├── model/
├── saved/
├── trainer/
├── utils/
└── train.py
```

### 4. How to train our model
Here we take coco dataset for example.

1. First, train the Encoder pretrain model.

```python
python3 train.py --cfg_path ./configs/coco/coco_pretrain.yaml
```

2. Second, train the seq2seq Decoder and refiner model.
Note that please check the path of the pretrained model is same as the PRETRAIN_WEIGHT in config file.

```python
python3 train.py --cfg_path ./configs/coco/coco_seq2seq.yaml
```


### 5. How to inference our model
You can control the inference by editing the TEST in the config.
The default setting will apply the inferencing on the entire test set.

```python
python3 train.py --cfg_path ./configs/coco/coco_seq2seq.yaml --checkpoint [PATH_TO_SEQ2SEQ_MODEL] --eval_only
```

After doing that, you can find the predicted layout in the saved/coco_F_seq2seq/test.
