from typing import Any, List, Optional, Tuple

from src.pipelines.base import Pipeline

pipeline_registry = {}


def register_pipeline(name: str, dataset_name: Optional[str] = None):
    def decorator(f):
        if dataset_name is None:
            pipeline_registry[name] = f
        else:
            pipeline_registry[name + "_" + dataset_name] = f
        return f

    return decorator


def create_pipeline(name: str, dataset_name: Optional[str] = None, **kwargs) -> Pipeline:
    if dataset_name is None:
        return pipeline_registry[name](**kwargs)
    return pipeline_registry[name + "_" + dataset_name](**kwargs)


def list_pipelines() -> List[str]:
    return list(pipeline_registry.keys())


def list_pipeline_args(name: str) -> List[Tuple[str, Any]]:
    import inspect

    signature = inspect.signature(pipeline_registry[name]).parameters
    return [(name, parameter.default) for name, parameter in signature.items()]


from .covariate_drift import *
from .ood import *
from .drift import *
