import numpy as np
from scipy.integrate import quad, dblquad
import matplotlib.pyplot as plt


#x_upper_limit = np.inf
#y_upper_limit = np.inf


y_upper_limit = 10000
x_upper_limit = 10000


Lambda = 0.5
T = 0.1
c1 = 0.01
c2 = 0.05


def f(x):
    return np.exp(-x)


def pT(x):
    if (x < T):
        return 1
    else:
        return 0
    # return 1 - np.exp(-T)


def g(x):
    return f(x)


def calculate_ET_short():
    integral1, _ = quad(lambda x: x**2 * f(x), 0, T)

    # Integral of x * pT(x) * f(x)
    integral2, _ = quad(lambda x: x * f(x), 0, T)
    # Calculating ETFCFS
    ETFCFS = (Lambda * integral1) / (2 * (1 - Lambda * integral2)) + integral2

    print(f'short jobs times: ETFCFS: {ETFCFS}')
    return ETFCFS

def calculate_ET_srv():
    # function for rho''_q
    def rho_prime_prime_new(q_value):
        def integrand_rho_q_1_adjusted(x):
            return pT(x) * x * f(x)

        def integrand_rho_q_2_adjusted(x):
            return (1 - pT(x)) * x * g(x)

        def integrand_rho_q_3_adjusted(x):
            return (1 - pT(x)) * g(x)

        rho_q_1_adjusted, _ = quad(integrand_rho_q_1_adjusted, 0, x_upper_limit)
        rho_q_3_adjusted, _ = quad(integrand_rho_q_3_adjusted, 0, x_upper_limit)
        rho_q_2_adjusted, _ = quad(integrand_rho_q_2_adjusted, 0, q_value)

        return Lambda * (c1 + rho_q_1_adjusted + rho_q_2_adjusted + c2 * rho_q_3_adjusted)


    # function for E[T(x, y)]_ext^PL
    def ET_ext_PL_perfect(x):
        rho_q_new = rho_prime_prime_new(x)
        integral_1, _ = quad(lambda x: pT(x) * (c1+ x)**2 * f(x), 0, x_upper_limit)
        integral_2, _ = quad(lambda x: (1 - pT(x)) * (c1 + c2 + x)**2 * g(x), 0, x)
        integral_12, _ = quad(lambda x: (1 - pT(x)) * (c1 + c2)**2 * g(x), x, x_upper_limit)
        integral_3, _ = quad(lambda x: (1 - pT(x)) * g(x), x,x_upper_limit)

        integral_last_part, _ = quad(lambda a: 1 / (1 - rho_prime_prime_new(max(0, x - a))), 0, x)

        #integral_last_part, _ = quad(lambda a: 1 / (1 - rho_prime_prime(a)), 0, x, limit=1000)
        #print(f'PERFECT: rho_q:{rho_q}, integral_1:{integral_1}, integral_2:{integral_2}, integral_3:{integral_3}, integral_last_part:{integral_last_part}')

        return (Lambda / (2 * (1 - rho_q_new)**2)) * (integral_1 + integral_2 + integral_12 + (x)**2 * integral_3) + integral_last_part

    # Calculating E[T_srv]
    #E_T_srv, _ = dblquad(lambda x, y: g(x, y) * ET_ext_PL(x, y), 0, np.inf, lambda x: 0, lambda x: np.inf)
    #E_T_srv = ET_ext_PL_perfect(1.2)

    E_T_srv = ET_ext_PL_perfect(1.0)
    print(f'PERFECT one_point_testPERFECT(1,1): {E_T_srv}')

    E_T_srv, _ = quad(lambda x: g(x) * ET_ext_PL_perfect(x), T, x_upper_limit)
    print(f'E_T_srv before nomalized: {E_T_srv}')
    normalization_factor, _ = quad(lambda x: g(x), T, x_upper_limit)

    # Normalize the mean response time
    E_T_srv_normalized = E_T_srv / normalization_factor if normalization_factor != 0 else 0
    print(f'long jobs time: {E_T_srv_normalized}')

    #z, _ = quad(lambda x: f(x)*(1-pT(x)), 0.001, x_upper_limit)

    #print(f'z: {z},long_job_effect: {z*E_T_srv_normalized}')

    return E_T_srv_normalized


def total_E(given_T):
    global T
    T = given_T
    z, _ = quad(lambda x: f(x)*(1-pT(x)), 0.001, x_upper_limit)
    #ET_short = calculate_ET_short()
    ET_long = z* calculate_ET_srv()
    print(f'z: {z}, long_job_effect: {ET_long}')
    #print(f'z: {z},short_job_effect: {ET_short}, long_job_effect: {ET_long}')

    #result = ET_short + ET_long
    #print(f'T:{T}, lambda:{Lambda}, result: {result}')
    #return result
    return ET_long


def save_results_to_file(Lambda, T, E_T_srv, filename=f'ET_{T}_{Lambda}_srv_results_to1.txt'):
    with open(filename, "w") as file:
        file.write(f"Lambda: {Lambda}\n")
        file.write(f"T: {T}\n")
        file.write(f"E[T_srv]: {E_T_srv}\n")


#E_T_sprpt  = srpt_book()
#print(f'sprpt book: {E_T_sprpt}')
E_T_srv = total_E(0.1)

# Now, create a range of T values and evaluate total_E for each
#T_values = np.linspace(0.05, 5, 5)  # Adjust range and number of points as needed
#E_values = [total_E(T) for T in T_values]

# Plotting
#plt.plot(T_values, E_values)
#plt.xlabel('T')
#plt.ylabel('Mean Response Time')
#plt.savefig('equation_vs_T.png')

#filename = f'ET_{T}_{Lambda}_ext_perfectP.txt'

#with open(filename, "w") as file:
#    file.write(f"Lambda: {Lambda}\n")
#    file.write(f"T: {T}\n")
#    file.write(f"E[T_srv]: {E_T_srv}\n")


