# SkipPredict: When to Invest in Predictions for Scheduling

 we consider the effect of the cost of predictions in queueing systems, removing the assumption in prior research that predictions are external to the system's resources and/or cost-free.
Additionally, we introduce a novel approach to utilizing predictions, Skippredict, designed to address their inherent cost. 
 Rather than uniformly applying predictions to all jobs, we propose a tailored approach that categorizes jobs to improve the effectiveness of prediction on performance.
 o achieve this, we employ one-bit ``cheap predictions'' to classify jobs as either short or long. 


## Datasets

We used three traces from Amvrosiadis et al.(2018): Twosigma, Google, and Trinity.
and two synthetic dataset, exponential distributed service time and Weilbull distributed service time.


### Models

We simulated all policies in the two models: the external cost model and the service time cost model.

To run the simulation of the external models, with skippredict, FCFS, and SPRPT:
```bash
# Example
$ python3 mg1_externalCosts.py
```

To run the simulation of the external model, 1bit:
```bash
# Example
$ python3 mg1_1bit_ext.py
```

To run the simulation of the server cost model, with skippredict, FCFS, and SPRPT:
```bash
# Example
$ python3 mg1_serverCosts.py
```

To run the simulation of the server cost model, 1bit:
```bash
# Example
$ python3 mg1_1bit_srv.py
```

Delaypredict simulation (external cost model):
```bash
# Example
$ python3 delayP_mg1_externalCosts.py
```

Delaypredict simulation (server time cost model):
```bash
# Example
$ python3 delayP_mg1_serverCosts.py
```