# Diffusion Dynamic Guidance Imitation Learning (DDGIL)


This repository provides the official PyTorch implementation of **Diffusion Dynamic Guidance Imitation Learning (DDGIL)**, a diffusion-based framework designed for offline multi-agent imitation learning with dynamic opponent adaptation.

## Overview

The following diagram illustrates the full workflow:

1. Train Expert Model / Use Pre-trained Weights (optional)
2. Rollout Data (collect trajectories) 
3. Train Model (DDGIL or Baseline)
4. Evaluate Against Experts of Varying Strength

## Installation

We recommend using a virtual environment to avoid package conflicts:

```bash
# Create and activate a virtual environment
python -m venv .env
source .env/bin/activate

# Install dependencies
pip install --upgrade pip
pip install -r requirements.txt
```

## Pre-trained Weights

We provide pre-trained weights for **Expert models (RL model)** at this [link](https://anonymous.4open.science/r/ddgi-318D/).

- Download the corresponding expert weights.
- Place them in the `weight` directory of the respective environment folder.

This setup allows you to evaluate or fine-tune models directly without retraining from scratch.



## Getting Started

### 1. Rollout Data Collection

To generate training data for a specific task:

1. Open `model/main_runEnv.py`
2. Set the desired number of data samples
3. Specify the target task (e.g., `push`, `tennis`, ...)

Before running, **you need to obtain the pretrained Expert model**.  
We provide pretrained expert weights that can be used directly. Please:

- Place the weights into a `weight/` folder inside each task directory (e.g., `push/weight/`)
- To obtain the expert weights yourself, you can also train them manually by running the corresponding `trainer.py` in each task folder (e.g., `push/trainer.py`)

Then, run:

```bash
python model/main_runEnv.py
```


### 2. Training


To train a DDGIL agent, follow these steps:

1. Open `model/main_trainer.py`.
2. In the Hydra configuration, modify the task name (e.g., `push`, `tennis`, etc.) to match your intended environment.
3. Run the following command:

```bash
python model/main_trainer.py
```

To train a baseline agent, follow these steps:

1. Open `model/baseline/b_trainer.py`.
2. In the Hydra configuration, modify both:
   - the model name (e.g., `bc`, `dbc`, etc.)
   - the task name (e.g., `push`, `tennis`, etc.)
3. Run the following command:

```bash
python model/baseline/b_trainer.py
```


### 3. Evaluation

Before running a trained model, follow these steps:

1. Open `model/main_playEnv.py`.
2. In the Hydra configuration, update both the **model name** and **task name** to match your intended setup.
3. If you want to change the parameters of the model, such as alpha, strength, etc., please modify it in the `config` of the model.
4. Verify and adjust task-specific parameters in the corresponding configuration file:
   - number of evaluation episodes
   - environment-specific settings

Once the configuration is properly set, execute the following command:

```bash
python model/main_playEnv.py
```

After execution, a .txt file will be generated containing detailed information such as:
1. Score progression
2. Task-specific metrics
3. Evaluation summaries

The result file will be saved in the `evaluation/result/` directory.
