def Load_model(args, is_single_agent=False):
    if is_single_agent:
        if args.model_name == 'ddgi':
            from model.demo.agent import Agent ##
            agent = Agent(args) ##
        elif args.model_name == 'bc':
            from model.baseline.BC.bc import BCAgent
            agent = BCAgent(args, eval=True)
        elif args.model_name == 'dp':
            from model.baseline.DBC.dp import DPAgent
            agent = DPAgent(args)
        elif args.model_name == 'dd':
            from model.baseline.DBC.dd import DDAgent
            agent = DDAgent(args)
        elif args.model_name == 'dbc':
            from model.baseline.DBC2.bc import DBCAgent
            agent = DBCAgent(args, eval=True)
        elif args.model_name == 'idql':
            from model.baseline.DBC.idql import IDQLAgent
            agent = IDQLAgent(args)
        

    
    return agent