import pandas as pd


def type2cat_inverse(category):
    # Original dictionary
    # print(category)
    if category == '接不到':
        return '接不到'
    """t2c = {'發短球': 1, '發長球': 10, '長球': 2, '殺球': 4, '切球': 9, '挑球': 8,
           '平球': 6, '網前球': 7, '推撲球': 3, '接殺防守': 5, '接不到': 11}"""
    t2c = {'發短球': 1, '發長球': 2, '長球': 3, '殺球': 4, '切球': 5, '挑球': 6,
           '平球': 7, '網前球': 8, '推撲球': 9, '接殺防守': 10, '接不到': 11}
    
    # {1: 'Serve short', 2: 'Clear', 3: 'Push Shot', 4: 'Smash', 5: 'Smash Defence', 
    #                          6: 'Drive', 7: 'Net Shot', 8: 'Lob', 9: 'Drop', 10: 'Serve long', 11: 'Missed shot'}
    
    c2t = {value: key for key, value in t2c.items()}
    
    # Return the shot type based on the category
    return c2t.get(int(category), "Unknown Category") 


def main():
    df1 = pd.read_csv("./evaluation/data/badminton/display_Kento MOMOTA_vs_CHOU Tien Chen_16.csv") # CHOU Tien Chen, Viktor AXELSEN, Kento MOMOTA
    df2 = pd.read_csv("./data/badminton/Kento MOMOTA_dataset.csv")
    df1_reordered = df1.reindex(columns=df2.columns)
    df1_reordered['type'] = df1_reordered['type'].apply(type2cat_inverse)
    
    current_get = None  # Initialize the tracking variable
    for index, row in df1_reordered.iloc[::-1].iterrows():
        if not pd.isna(row["getpoint_player"]):  # Check if "getpoint_player" is not NaN
            current_rally_id = row['rally_id']  # Update current_rally_id
            current_get = row['getpoint_player']  # Update current_get
        else:
            # Modify the DataFrame directly using the index
            df1_reordered.at[index, 'getpoint_player'] = current_get
    for index, row in df1_reordered.iterrows():
        if not pd.isna(row['frame_num']) and row['type'] == '接不到':
            # Safely update the previous row using .loc
            if index > 0:  # Ensure index-1 exists
                df1_reordered.loc[index - 1, 'win_reason'] = row['win_reason']
                df1_reordered.loc[index - 1, 'lose_reason'] = row['lose_reason']
        
    # Drop rows where 'type' is '接不到'
    df1_reordered = df1_reordered[(df1_reordered['type'] != '接不到') | (pd.isna(df1_reordered['frame_num']))]
    # df1_reordered.to_csv("Test_preprocess/Current_dataset/result_data/reordered_csv1.csv", index=False)
    """df1_reordered['landing_x'] /= 177.5
    df1_reordered['landing_y'] = -1 * (df1_reordered['landing_y'] / 240) + 1
    df1_reordered['player_location_x'] /= 177.5
    df1_reordered['player_location_y'] /= 240
    df1_reordered['opponent_location_x'] /= 177.5
    df1_reordered['opponent_location_y'] /= 240"""
    
    df1_reordered.to_csv("./evaluation/data/badminton/r_display_Kento MOMOTA_vs_CHOU Tien Chen_16.csv", index=False)

if __name__ == "__main__":
    main()