import sys
import os
sys.path.append(os.path.abspath('./'))
import hydra
import gc
import torch
import time
import psutil
from env import playAtari, playClassic, playMPE, playBadminton


"""
            |  agent state  |   adv state  | agent num | adv num | action | traj length
tag         |       14      |      16      |     1     |    3    |   5    |     25
push        |       19      |      8       |     1     |    1    |   5    |     25
spread      |       18      |      -       |     3     |    0    |   5    |     25
connect4    |     2*6*7     |     2*6*7    |     1     |    1    |   7    |     42 (21)
holdem      |       72      |      72      |     1     |    1    |   4    |     50 (25)
boxing      |    84*84*6    |    84*84*6   |     1     |    1    |   18   |     256
tennis      |    84*84*6    |    84*84*6   |     1     |    1    |   18   |     128
badminton   |       17      |      17      |     1     |    1    |   15   |     60 (30)
"""


"""
To proceed with evaluation, you must manually modify both the model name and the task name in the Hydra configuration to match your intended setup.

./configs/[ddgi, bc, dbc, dp, dd]
config_name=[push, tag, spread, tennis, box, connect4, holdem, badminton]
"""

@hydra.main(config_path="./configs/ddgi", config_name="box", version_base=None)
def main(args, isa=False):
    # setting for cache
    gc.collect()
    torch.cuda.empty_cache()
    print(f"--- Play Env: '{args.env_name}' with Epoch '{args.eval.episodes}' --- ")
    print(f"--- Use Agent: '{args.eval.IsAgent}' --- ")
    print('======================================================\n')
    
    # cost
    start_time = time.time()
    start_mem = psutil.Process().memory_info().rss

    if args.env_name in ['push', 'tag', 'spread']:
        playMPE.main(args, is_single_agent=True)

    elif args.env_name in ['tennis', 'box']:
        playAtari.main(args, is_single_agent=True)

    elif args.env_name in ['connect4']:
        playClassic.main_connect(args, is_single_agent=True)
    
    elif args.env_name in ['holdem']:
        playClassic.main_holdem(args, is_single_agent=True)
    
    elif args.env_name in ['badminton']:
        playBadminton.main(args, is_single_agent=True)

    print(f"============ Finish Playing in env: {args.env_name} ============\n")
    
    end_time = time.time()
    cost_min = (end_time - start_time) // 60
    cost_sec = (end_time - start_time) % 60
    print(f"Time Cost:{cost_min}m {cost_sec}s")
    
    end_mem = psutil.Process().memory_info().rss
    print(f"Memory Use(bytes): {((end_mem - start_mem) / (1024 ** 3)):.4f} GB")


if __name__ == "__main__":
    main()