import pandas as pd
import os


def main():
    data = pd.read_csv('./data/badminton/All_dataset.csv')
    player_name = 'Viktor AXELSEN' # Viktor AXELSEN, Kento MOMOTA
    result_path = './data/badminton/'

    now_game = 0
    player_game = []

    for index, row in data.iterrows(): 
        if row['player'] == player_name:
            if row['match_id'] == now_game:
                continue
            else:
                now_game = row['match_id']
                player_game.append(now_game)

    print(player_game)

    # for index, row in data.iterrows(): 
    new_df = data[data['match_id'].isin(player_game)]
    new_df.to_csv(os.path.join(result_path, f"{player_name}_dataset.csv"), index=False)
    
    
if __name__ == "__main__":
    main()