﻿Below is a list of the files in this directory

* path_experiment_runner.py - Runs the experiments.
* instance_creator.py - Contains the code used to generate the synthetic data
* reconfiguration.py - Contains the code for generating the reconfiguration paths.
* tables_and_plots_path.py - Code that was used to generate the tables and plots in the paper.
* vote_reader.py - Functions for reading the instance files and generating the Netflix instances from the Netflix data.

Additionally abcvoting directory contains the modified abcvoting library.
Requirements.txt lists the libraries and their versions used for the experiments.


We use python 3.10.12.
To run the experiments, move to the code directory and run

```pip install -r requirements.txt```

Replace the abcvoting library with our library. If you are using a virtual environment, this should be in /venv/lib/python[python version]/site-packages.

Place the input data in a folder called path_data in the current folder. 

To run experiment on the data, run the following command:
``` 
python3 path_experiment_runner.py --base_folder [folder that houses the source folders] --source_folder [folders within base folders where the input files are]  --rules pav cc --committee_sizes [desired committee sizes]
```

With the data from path_data in the supplementary material, you can find paths on the synthetic instances with the following commands:
```
python3 path_experiment_runner.py --base_folder path_data/manhattan/ --source_folder  d2_r0_10  d2_r0_20  d2_r0_30  d2_r0_40	d2_r0_50  d2_r0_60  d2_r0_70  --rules pav cc --committee_sizes 3 4 5
python3 path_experiment_runner.py --base_folder path_data/resampling/ --source_folder  pfresampling_p0_05_f0_25  pfresampling_p0_05_f0_75  pfresampling_p0_25_f0_25  pfresampling_p0_25_f0_75	pfresampling_p0_50_f0_25  pfresampling_p0_50_f0_75  pfresampling_p0_75_f0_25  pfresampling_p0_75_f0_75 pfresampling_p0_05_f0_50  pfresampling_p0_05_f1_00  pfresampling_p0_25_f0_50  pfresampling_p0_25_f1_00	pfresampling_p0_50_f0_50  pfresampling_p0_50_f1_00  pfresampling_p0_75_f0_50  pfresampling_p0_75_f1_00 --rules pav cc --committee_sizes 3 4 5````


The output files are produced in the respective folders, i.e., for manhattan data the output file is produced in the resampling folder.

To create the running time summaries, run ```python3 tables_and_plots_path.py```. This will create summary statistics about the data. If you do not wish to include our original results, remove all of the original stats_path\*.csv files.


