# HD/VHD
## Requirements
```
pandas==1.1.3
tqdm==4.50.2
six==1.15.0
matplotlib==3.3.2
numpy==1.19.2
torch==1.8.0+cu111
nibabel==3.2.1
torchvision==0.9.0+cu111
torchmetrics==0.4.0
opencv_python==4.5.2.54
pytorch_lightning==1.3.7
Pillow==8.4.0
PyYAML==6.0
hilbertcurve==2.0.5
```
Please refer to requirement.txt for more information of dependency.

## Public Dataset

### ActivityNet
Download data [here](http://activity-net.org/)
### Large-COVID-19
Download data [here](https://www.kaggle.com/maedemaftouni/large-covid19-ct-slice-dataset)


## Running
### Training Teacher Model
Before knowledge distillation, a well-trained teacher model is required. 

```python train_anet.py``` for ActivityNet

```python train_covid.py``` for Large-COVID-19

### Training With Knowledge Distillation 

```python train_kd.py``` for either ActivityNet or Large-COVID-19 depend on different .yaml configuration.

The training scripts also include the entry of validation/text.

Please refer to the paper for more details.
